#if defined(__WXGTK__) || defined(__WXMOTIF__)
        #include <wx/wx.h>
#endif

#include <wx/wxprec.h>
#include <fstream>
#include <string>

#include "TextFileViewer.h"

using namespace std;

TextFileViewer::TextFileViewer(wxWindow* parent, const char* caption, const char* filename) 
: wxFrame(parent, -1, wxString(caption, wxConvLocal))
{
	wxBoxSizer* frameSizer = new wxBoxSizer(wxVERTICAL);

	mTextCtrl = new wxTextCtrl(this, -1, _T(""),wxDefaultPosition, wxSize(400,400), 
		wxTE_MULTILINE | wxTE_READONLY | wxTE_RICH);


	frameSizer->Add(mTextCtrl, 1, wxEXPAND);

	ifstream input(filename);

	if (!input.good()) {
		(*mTextCtrl) << _T("problem opening ") << wxString(filename, wxConvLocal) << _T(".\n");
	}

	string str;
	while (getline(input, str)) {
		(*mTextCtrl) << wxString(str.c_str(), wxConvLocal);

#ifdef __WXMSW__
		(*mTextCtrl) << _T('\n');
#endif
	}


	input.close();

	SetSizer(frameSizer);

	frameSizer->Fit(this);

}

