#ifndef OUTPUTTER_BASE_H_
#define OUTPUTTER_BASE_H_

#include "OutputList.h"
#include "SeriesHandler.h"

#include <map>
#include <string>

#include <wx/filename.h>

namespace jcs {



class Options 
{
public:
	std::string pathname;
	std::map <std::string, bool> boolOptions;
	std::map <std::string, int> intOptions;
	std::map <std::string, wxString> stringOptions;
	std::map <std::string, double> doubleOptions;
};


class OutputterBase {

public :

	OutputterBase(const Options& options);
//	OutputterBase(SeriesHandler* series);
	virtual ~OutputterBase();

	virtual void UpdateOutputForSeries(SeriesHandler* handler) = 0;
	virtual void RemoveSeries(const std::string& seriesUid) = 0;

	virtual int ConvertSeries(SeriesHandler* handler) = 0;

	OutputList mOutputList;

	// return value = 1 means output list has changed
//	virtual int ShowOptionsDlg();

	//wxFileName GetFileNameFromVolId(const VolId& VolId);
	ImageFileName GetImageFileName(const std::string& series_uid, const std::string& name);

	wxFileName GetFileName(const std::string& series_uid);

	void ChangeFileName(const std::string& series_uid, const std::string& new_name);
	void ChangeDirName(const std::vector<std::string>& series_uids, const std::string& new_name, 
		int position);

	//void OverrideOption(const std::string& series_uid, const std::string& id, bool value);
	//void OverrideOption(const std::string& series_uid, const std::string& id, double value);
	//void OverrideOption(const std::string& series_uid, const std::string& id, std::string value);
	//void OverrideOption(const std::string& series_uid, const std::string& id, int value);

//	virtual void OnOveride(const std::string& series_uid) {}
	bool mSplitDirsFlag;

	virtual void SetOption(const std::string& name, int value) {}
	virtual void SetOption(const std::string& name, bool value);

	struct NameField
	{
		std::string name;
		bool value;
		NameField(std::string n, bool v) : name(n), value(v) {}
		NameField() {}
	};

	enum {
		PatientName,
		PatientId,
		SeriesDate,
		SeriesTime,
		StudyId,
		StudyDescription,
		SeriesNumber,
		SequenceName,
		ProtocolName,
		SeriesDescription
	};

	typedef std::map<int, NameField> FieldMap;
	FieldMap defaultNameFields;

protected :
//	virtual OutputList GetOutputFileInfos(/*FileInfo& invariant, SeriesHandler* handler*/) = 0;
	virtual void FillInDefaultDirs(ImageFileName& name, SeriesHandler* series);

	std::string GenerateDefaultPrefix(SeriesHandler* series);

//	SeriesHandler* mSeries;
	std::map<VolId, std::string> volKeyMap;

	Options mOptions;

	static Options GetBaseOptions();

	std::map<std::string, Options> overrides;
	

private :

//	virtual void AddSeriesInfo(/*const DicomSeries& series*/);
//	FileInfo GetSeriesInfo(/*const DicomSeries& series*/);
//	std::map<std::string, FileInfo> mSeriesInfoMap;


};


}


#endif

