
#include <string>
#include <vector>

#include "SeriesHandler.h"
#include "NewMetaVolume.h"
#include "NewMetaOutputter.h"
//#include "Basic3DConversion.h"

using namespace std;
using namespace jcs;

NewMetaOutputter::NewMetaOutputter() : 
Basic3DOutputter(CreateOptions())
{
	if (rawExtension == _T("")) saveHeaderOnly = true;
	else saveHeaderOnly = false;

}

Options
NewMetaOutputter::CreateOptions()
{
	Options options = Get3DOptions();
	options.pathname = "MetaImage";
	options.stringOptions["header"] = _T("mhd");
	options.stringOptions["raw"] = _T("raw");

	return options;
}


BasicVolumeFormat* 
NewMetaOutputter::GetOutputVolume(const char* file)
{
	return new NewMetaVolume(file, headerExtension.mb_str(wxConvLocal), rawExtension.mb_str(wxConvLocal));
}

int
NewMetaOutputter::ConvertSeries(SeriesHandler* handler)
{
	int bits_allocated, pixel_rep = 0;
	handler->Find("BitsAllocated", bits_allocated);
	handler->Find("PixelRepresentation", pixel_rep);

	switch (bits_allocated + pixel_rep) {

		case 9 : {
			MetaConversion<wxInt8> conversion(this, handler);
			conversion.Convert();
				 }
			break;

		case 8 :{
			MetaConversion<wxUint8> conversion(this, handler);
			conversion.Convert();
				}
			break;

		case 17 :{
			MetaConversion<wxInt16> conversion(this, handler);
			conversion.Convert();
				 }
			break;

		case 16 :
		default :{
			MetaConversion<wxUint16> conversion(this, handler);
			conversion.Convert();
				 }
	}

	return 1;
}

void
NewMetaOutputter::SetSaveHeader(bool value)
{
	saveHeaderOnly = value;
	if (saveHeaderOnly) {
		rawExtension = _T("");
	}
	else {
		rawExtension = _T("raw");
	}
}

void
NewMetaOutputter::SetOption(const string& name, bool value)
{
	Basic3DOutputter::SetOption(name, value);
	if (name.find("ho") != string::npos) SetSaveHeader(value);
}



template <class T>
MetaConversion<T>::MetaConversion(Basic3DOutputter* outputter, SeriesHandler* handler)
: Basic3DConversion<T>(outputter, handler)
{
	mHeader = new NewMetaHeader();
}

template <class T>
MetaConversion<T>::~MetaConversion()
{
	delete mHeader;
}


template <class T> void
MetaConversion<T>::GetHeaderForSeries()
{
	int nVolumes = this->GetNumberOfVolumes();

	int dimensionality = this->mOutputter->GetDimensionality(this->mHandler->GetSeriesUid());
	bool save4D = (dimensionality == 4 && nVolumes > 1);

	if (save4D) mHeader->nDims = 4;
	else mHeader->nDims = 3;

	mHeader->dimSize[0] = this->mHandler->GetColumns();
	mHeader->dimSize[1] = this->mHandler->GetRows();
	mHeader->dimSize[2] = this->mHandler->GetNumberOfSlices();
	// dimSize[2] recalculated in mConvert 
	if (save4D) mHeader->dimSize[3] = nVolumes;

	vector<double>voxel_size = this->mHandler->GetVoxelSize();
	mHeader->elementSpacing[0] = voxel_size[0];
	mHeader->elementSpacing[1] = voxel_size[1];
	mHeader->elementSpacing[2] = voxel_size[2];

	// elementSpacing[2] recalculated in mConvert
	if (save4D) mHeader->elementSpacing[3] = this->mHandler->GetVolumeInterval();

	mHeader->byteOrderMSB = this->mHandler->IsBigEndian();

	this->mHandler->Find("SamplesPerPixel", mHeader->numberOfChannels);
	int bits_allocated, pixel_rep = 0;
	this->mHandler->Find("BitsAllocated", bits_allocated);
	this->mHandler->Find("PixelRepresentation", pixel_rep);

	switch (bits_allocated + pixel_rep) {

		case 16 : mHeader->elementType = MET_USHORT;
			break;

		case 9 : mHeader->elementType = MET_CHAR;
			break;

		case 8 : mHeader->elementType = MET_UCHAR;
			break;

		case 17 : mHeader->elementType = MET_SHORT;
			break;

		default : mHeader->elementType = MET_USHORT;

	}


	mHeader->origin[0] = 0;
	mHeader->origin[1] = 0;
	mHeader->origin[2] = 0;

	NewMetaOutputter* out = dynamic_cast<NewMetaOutputter*>(this->mOutputter);
	for(vector<string>::iterator it = out->fields.begin();
		it != out->fields.end(); ++it) {
		string value;
		this->mHandler->Find(*it, value);
		mHeader->extraFields.push_back(*it);
		mHeader->extraFields.back().append(" = ");
		mHeader->extraFields.back().append(value);
	}

	// set to default, may change in ConvertmHeaderOnly.
	mHeader->headerSize = -1;


}

template <class T> void
MetaConversion<T>::CompleteHeaderForVolume(std::pair<VolId, Volume<T> > volPair)
{
	int n_slices = volPair.second.size();
	mHeader->dimSize[2] = n_slices;

	if (n_slices > 1)
		mHeader->elementSpacing[2] = volPair.second.GetSpacing();

	vector<double> ipp = this->mHandler->GetIppForFirstSlice(volPair.first);
	for (unsigned int i = 0; i < ipp.size(); ++i)
		mHeader->origin[i] = ipp.at(i);
	mHeader->origin[3] = 0;

	mHeader->orientation.clear();
	mHeader->orientation = this->mHandler->GetRotationMatrix(volPair.first);

	wxFileName name = this->mOutputter->GetFileNameFromVolId(volPair.first);

	if (name.GetName() == _T("error")) {
		wxLogError(_T("File name error"));
		return;
	}

	name.SetExt(this->mOutputter->rawExtension.c_str());
	mHeader->elementFile = name.GetFullName().mb_str(wxConvLocal);

}

template <class T> void
MetaConversion<T>::Convert()
{
	NewMetaOutputter* out = dynamic_cast<NewMetaOutputter*>(this->mOutputter);
	if (!out->SaveHeaderOnly() ) {
		Basic3DConversion<T>::Convert();
		return;
	}

	string series_uid = this->mHandler->GetSeriesUid();
	int dimensionality = this->mOutputter->GetDimensionality(series_uid);

	GetHeaderForSeries();

	typedef map <VolId, Volume<T> > vMapType;
	vMapType volumes;
	this->mHandler->GetVolumes(volumes);


	if (dimensionality == 4) {
		
		//int headerSize = this->mHandler->GetFirstFile().GetHeaderSize();
		//int fileSize = this->mHandler->GetFirstFile().GetFileSize();
		//int dataSize = mHeader.dimSize[0] * mHeader.dimSize[1] 
		//	* MET_ValueTypeSize[mHeader.elementType];

		//if (fileSize > (headerSize + dataSize))
		//	mHeader.headerSize = headerSize;

		wxFileName file = this->mOutputter->GetFileName(series_uid);
		if (file.GetName() == _T("error")) {
			wxLogError(_T("File name error"));
			return;
		}
		file.SetExt(_T(""));

		BasicVolumeFormat* outputVolume = this->mOutputter->GetOutputVolume(file.GetFullPath().mb_str(wxConvLocal));

		typename vMapType::iterator it = volumes.begin();
		CompleteHeaderForVolume(*it);
		mHeader->elementFile = "LIST";

		mHeader->sourceFileVector.clear();
		while(it != volumes.end()) {

			map<float, string>::iterator dicom_names = it->second.dicomFiles.begin();
			while (dicom_names != it->second.dicomFiles.end()) {
				mHeader->sourceFileVector.push_back(dicom_names->second);
				++dicom_names;
			}

			++it;
			wxTheApp->Yield();
		}
		outputVolume->WriteHeader(GetHeader());

		delete outputVolume;

	}

	else {

		typename vMapType::iterator it = volumes.begin();

		while(it != volumes.end()) {

			CompleteHeaderForVolume(*it);
			mHeader->elementFile = "LIST";

			wxFileName file = this->mOutputter->GetFileNameFromVolId(it->first);
			if (file.GetName() == _T("error")) {
				wxLogError(_T("File name error"));
				break;
			}

			file.SetExt(_T(""));
			BasicVolumeFormat* outputVolume = this->mOutputter->GetOutputVolume(file.GetFullPath().mb_str(wxConvLocal));
		
			mHeader->sourceFileVector.clear();
		
			map<float, string>::iterator dicom_names = it->second.dicomFiles.begin();
			while (dicom_names != it->second.dicomFiles.end()) {
				mHeader->sourceFileVector.push_back(dicom_names->second);
				++dicom_names;
			}

			outputVolume->WriteHeader(GetHeader());

			typedef std::map<float, std::vector<T> > SliceMap;

			delete outputVolume;
			++it;
			wxTheApp->Yield();
		}

	}

}
