/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Drawable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeNode;

public class TreeTrunk {
    private OutputLog slog;
    private Map shadowdefs_map;
    private int num_leafs;
    private int leaf_bytesize;
    private List treenodes;
    private TreeNode leaf;
    private TreeNode root;
    private Drawable last_dobj_added;
    private LineIDMap lineIDmapOne;

    public TreeTrunk(OutputLog in_slog, Map in_shadefs) {
        this.slog = in_slog;
        this.shadowdefs_map = in_shadefs;
        this.num_leafs = this.slog.getNumChildrenPerNode();
        this.leaf_bytesize = this.slog.getTreeLeafByteSize();
        this.leaf = new TreeNode();
        this.leaf.setMapOfTopologyToShadowDef(this.shadowdefs_map);
        this.leaf.setTreeNodeID(new TreeNodeID(0, 0));
        this.treenodes = new LinkedList();
        this.treenodes.add(this.leaf);
        this.root = this.leaf;
        this.last_dobj_added = null;
        this.lineIDmapOne = null;
    }

    public void addDrawable(Drawable dobj) {
        if (this.leaf.getNodeByteSize() + dobj.getByteSize() > this.leaf_bytesize) {
            this.switchToNextBranch();
        }
        boolean hasDrawableBeenStored = false;
        Iterator nodes_itr = this.treenodes.iterator();
        while (nodes_itr.hasNext()) {
            TreeNode node = (TreeNode)nodes_itr.next();
            if (!(node.getEarliestTime() <= dobj.getEarliestTime())) continue;
            node.add(dobj);
            this.last_dobj_added = dobj;
            hasDrawableBeenStored = true;
            break;
        }
        if (!hasDrawableBeenStored) {
            this.root.add(dobj);
            this.last_dobj_added = dobj;
            hasDrawableBeenStored = true;
            this.root.affectEarliestTime(dobj.getEarliestTime());
        }
    }

    private void switchToNextBranch() {
        TreeNode node;
        TreeNodeID nextBranchNodeID = new TreeNodeID(this.leaf.getTreeNodeID());
        nextBranchNodeID.toNextSibling();
        Iterator nodes_itr = this.treenodes.iterator();
        while (nodes_itr.hasNext() && !(node = (TreeNode)nodes_itr.next()).getTreeNodeID().equals(nextBranchNodeID)) {
            node.finalizeLatestTime(this.last_dobj_added);
            this.slog.writeTreeNode(node);
            node.empty();
            double prev_node_earliest_time = node.getEarliestTime();
            node.setEarliestTime(node.getLatestTime());
            node.setTreeNodeID(nextBranchNodeID);
            nextBranchNodeID.toParent(this.num_leafs);
            if (nodes_itr.hasNext()) continue;
            this.root = new TreeNode(node);
            this.root.setMapOfTopologyToShadowDef(this.shadowdefs_map);
            this.root.setTreeNodeID(nextBranchNodeID);
            this.root.affectEarliestTime(prev_node_earliest_time);
            this.treenodes.add(this.root);
            break;
        }
    }

    public boolean flushToFile() {
        if (this.last_dobj_added == null) {
            return false;
        }
        Iterator nodes_itr = this.treenodes.iterator();
        while (nodes_itr.hasNext()) {
            TreeNode node = (TreeNode)nodes_itr.next();
            node.finalizeLatestTime(this.last_dobj_added);
            this.slog.writeTreeNode(node);
            if (!nodes_itr.hasNext()) {
                this.lineIDmapOne = node.getIdentityLineIDMap();
                node.summarizeCategories();
            }
            node.empty();
        }
        this.last_dobj_added = null;
        return true;
    }

    public LineIDMap getIdentityLineIDMap() {
        return this.lineIDmapOne;
    }
}

