/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.ColorAlpha;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorNameMap {
    private static HashMap colormap = null;

    public static void initMapFromRGBtxt(String filename) {
        InputStream ins = ClassLoader.getSystemResourceAsStream(filename);
        if (ins == null) {
            System.err.println("ColorNameMap: Could NOT locate " + filename + " in CLASSPATH.  Exiting...!");
            System.exit(1);
        }
        colormap = new HashMap(800);
        try {
            String line;
            InputStreamReader insrdr = new InputStreamReader(ins);
            BufferedReader bufrdr = new BufferedReader(insrdr, 20480);
            while ((line = bufrdr.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                int red = Integer.parseInt(tokens.nextToken());
                int green = Integer.parseInt(tokens.nextToken());
                int blue = Integer.parseInt(tokens.nextToken());
                ColorAlpha aRGB = new ColorAlpha(red, green, blue);
                String colorname = tokens.nextToken();
                while (tokens.hasMoreTokens()) {
                    colorname = colorname + " " + tokens.nextToken();
                }
                colormap.put(colorname, aRGB);
            }
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    public static ColorAlpha getColorAlpha(String in_colorname) {
        int len = in_colorname.indexOf(58);
        String colorname = len != -1 ? in_colorname.substring(0, len) : in_colorname;
        ColorAlpha color = (ColorAlpha)colormap.get(colorname);
        if (color == null) {
            System.err.println("ColorNameMap: " + colorname + " not found." + "Assign Default MPE Colors!");
            return ColorAlpha.getNextDefaultColor();
        }
        return color;
    }

    public static String getString() {
        StringBuffer rep = new StringBuffer("ColorNameMap : \n");
        int idx = 0;
        Iterator entries = colormap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            rep.append(++idx + ", " + (String)entry.getKey() + " -> " + (ColorAlpha)entry.getValue() + "\n");
        }
        return rep.toString();
    }

    public static final void main(String[] args) {
        String filename = "jumpshot.colors";
        ColorNameMap.initMapFromRGBtxt(filename);
        System.out.println("navy blue is " + ColorNameMap.getColorAlpha("navy blue"));
        System.out.println("green:dimple3 is " + ColorNameMap.getColorAlpha("green:dimple3"));
    }
}

