/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.util.Iterator;
import logformat.slog2.input.TreeTrunk;
import viewer.timelines.SearchCriteria;
import viewer.zoomable.YaxisTree;

public class SearchTreeTrunk {
    private static final Drawable.Order INCRE_STARTTIME_ORDER = Drawable.INCRE_STARTTIME_ORDER;
    private static final Drawable.Order DECRE_STARTTIME_ORDER = Drawable.DECRE_STARTTIME_ORDER;
    private static final boolean IS_NESTABLE = true;
    private TreeTrunk treetrunk;
    private boolean isConnectedComposite;
    private SearchCriteria criteria;
    private Drawable last_found_dobj;

    public SearchTreeTrunk(TreeTrunk treebody, YaxisTree y_tree, boolean isComposite) {
        this.treetrunk = treebody;
        this.criteria = new SearchCriteria(y_tree);
        this.isConnectedComposite = isComposite;
        this.last_found_dobj = null;
    }

    public Drawable previousDrawable(double searching_time) {
        Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, DECRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        this.criteria.initMatch();
        while (dobjs.hasNext()) {
            Drawable dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || !(dobj.getEarliestTime() <= searching_time) || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            this.last_found_dobj = dobj;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable previousDrawable() {
        if (this.last_found_dobj == null) {
            System.err.println("SearchTreeTrunk.previousDrawable(): Unexpected error, last_found_dobj == null");
            return null;
        }
        Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, DECRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        this.criteria.initMatch();
        while (dobjs.hasNext()) {
            Drawable dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || DECRE_STARTTIME_ORDER.compare(dobj, this.last_found_dobj) <= 0 || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            this.last_found_dobj = dobj;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable nextDrawable(double searching_time) {
        Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        this.criteria.initMatch();
        while (dobjs.hasNext()) {
            Drawable dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || !(dobj.getEarliestTime() >= searching_time) || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            this.last_found_dobj = dobj;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable nextDrawable() {
        if (this.last_found_dobj == null) {
            System.err.println("SearchTreeTrunk.nextDrawable(): Unexpected error, last_found_dobj == null");
            return null;
        }
        Iterator dobjs = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        this.criteria.initMatch();
        while (dobjs.hasNext()) {
            Drawable dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || INCRE_STARTTIME_ORDER.compare(dobj, this.last_found_dobj) <= 0 || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            this.last_found_dobj = dobj;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public BufForTimeAveBoxes createBufForTimeAveBoxes(TimeBoundingBox timebox) {
        Drawable dobj;
        Shadow sobj;
        BufForTimeAveBoxes buf2statboxes = new BufForTimeAveBoxes(timebox);
        this.criteria.initMatch();
        Iterator sobjs = this.treetrunk.iteratorOfLowestFloorShadows(timebox, INCRE_STARTTIME_ORDER, true);
        while (sobjs.hasNext()) {
            sobj = (Shadow)sobjs.next();
            if (!sobj.getCategory().isVisiblySearchable() || !sobj.containSearchable() || !this.criteria.isMatched(sobj)) continue;
            buf2statboxes.mergeWithNestable(sobj);
        }
        Iterator dobjs = this.treetrunk.iteratorOfRealDrawables(timebox, INCRE_STARTTIME_ORDER, this.isConnectedComposite, true);
        while (dobjs.hasNext()) {
            dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            buf2statboxes.mergeWithNestable(dobj);
        }
        buf2statboxes.setNestingExclusion();
        dobjs = this.treetrunk.iteratorOfRealDrawables(timebox, INCRE_STARTTIME_ORDER, this.isConnectedComposite, false);
        while (dobjs.hasNext()) {
            dobj = (Drawable)dobjs.next();
            if (!dobj.getCategory().isVisiblySearchable() || !dobj.containSearchable() || !this.criteria.isMatched(dobj)) continue;
            buf2statboxes.mergeWithNestless(dobj);
        }
        sobjs = this.treetrunk.iteratorOfLowestFloorShadows(timebox, INCRE_STARTTIME_ORDER, false);
        while (sobjs.hasNext()) {
            sobj = (Shadow)sobjs.next();
            if (!sobj.getCategory().isVisiblySearchable() || !sobj.containSearchable() || !this.criteria.isMatched(sobj)) continue;
            buf2statboxes.mergeWithNestless(sobj);
        }
        return buf2statboxes;
    }
}

