/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import viewer.legends.LegendTable;
import viewer.legends.LegendTableModel;
import viewer.legends.Triangular3DIcon;

public class GenericHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 2400L;
    private JTable table_view;
    private int renderer_column;
    private LegendTableModel table_model;
    private JTableHeader table_header;
    private Color released_bg_color;
    private Color pressed_bg_color;
    private Icon released_tab_icon;
    private Icon pressed_tab_icon;

    public GenericHeaderRenderer(LegendTable in_table, int icolumn) {
        this.table_view = in_table;
        this.renderer_column = icolumn;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        super.setText(this.table_model.getColumnName(icolumn));
        super.setToolTipText(this.table_model.getColumnToolTip(icolumn));
        super.setHorizontalAlignment(0);
        super.setForeground(this.table_model.getColumnNameForeground(icolumn));
        this.released_bg_color = this.table_model.getColumnNameBackground(icolumn);
        this.pressed_bg_color = this.released_bg_color.darker();
        super.setBackground(this.released_bg_color);
        this.table_header = null;
        this.released_tab_icon = null;
        this.pressed_tab_icon = null;
    }

    public void initPressablePullDownTab() {
        boolean is_raised_tab = this.table_model.isRaisedColumnNameIcon(this.renderer_column);
        this.released_tab_icon = new Triangular3DIcon(1, true, is_raised_tab);
        this.pressed_tab_icon = new Triangular3DIcon(1, false, is_raised_tab);
        this.table_header = this.table_view.getTableHeader();
        super.setHorizontalTextPosition(2);
        super.setIcon(this.released_tab_icon);
        this.table_header.addMouseListener(new RendererMouseHandler());
    }

    public void setPressed(boolean isPressed) {
        if (isPressed) {
            super.setIcon(this.pressed_tab_icon);
            super.setBackground(this.pressed_bg_color);
        } else {
            super.setIcon(this.released_tab_icon);
            super.setBackground(this.released_bg_color);
        }
        super.revalidate();
        super.repaint();
        this.table_header.repaint();
    }

    private class RendererMouseHandler
    extends MouseAdapter {
        private GenericHeaderRenderer renderer;

        public RendererMouseHandler() {
            this.renderer = GenericHeaderRenderer.this;
        }

        private boolean isMouseEventAtMyColumn(MouseEvent evt) {
            Point click = evt.getPoint();
            int click_column = GenericHeaderRenderer.this.table_header.columnAtPoint(click);
            int model_column = GenericHeaderRenderer.this.table_view.convertColumnIndexToModel(click_column);
            return model_column == GenericHeaderRenderer.this.renderer_column;
        }

        public void mousePressed(MouseEvent evt) {
            if (this.isMouseEventAtMyColumn(evt)) {
                this.renderer.setPressed(true);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.isMouseEventAtMyColumn(evt)) {
                this.renderer.setPressed(false);
            }
        }
    }
}

