/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import viewer.common.Dialogs;
import viewer.common.TopWindow;

public class HTMLviewer
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 14000L;
    private JTextField input_fld;
    private JEditorPane html_panel;
    private JButton init_btn;
    private JButton backward_btn;
    private JButton forward_btn;
    private JButton refresh_btn;
    private JButton close_btn;
    private Stack url_undo_stack;
    private Stack url_redo_stack;

    public HTMLviewer(String title_str) {
        super(TopWindow.First.getWindow());
        if (title_str != null) {
            this.setTitle(title_str);
        } else {
            this.setTitle("HTML viewer");
        }
        super.setSize(600, 400);
        super.setBackground(Color.gray);
        super.getContentPane().setLayout(new BorderLayout());
        this.url_undo_stack = new Stack();
        this.url_redo_stack = new Stack();
        super.getContentPane().add((Component)this.createToolBar(), "North");
        int fld_width = 400;
        int fld_height = 25;
        Dimension min_size = new Dimension(0, fld_height);
        Dimension max_size = new Dimension(Short.MAX_VALUE, fld_height);
        Dimension pref_size = new Dimension(fld_width, fld_height);
        JPanel center_panel = new JPanel();
        center_panel.setLayout(new BoxLayout(center_panel, 1));
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BoxLayout(top_panel, 0));
        JLabel URL_label = new JLabel("    URL : ");
        top_panel.add(URL_label);
        this.input_fld = new JTextField();
        this.input_fld.setMinimumSize(min_size);
        this.input_fld.setMaximumSize(max_size);
        this.input_fld.setPreferredSize(pref_size);
        top_panel.add(this.input_fld);
        center_panel.add(top_panel);
        JScrollPane scroll_panel = new JScrollPane();
        scroll_panel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.html_panel = new JEditorPane();
        this.html_panel.setEditable(false);
        scroll_panel.getViewport().add(this.html_panel);
        center_panel.add(scroll_panel);
        super.getContentPane().add((Component)center_panel, "Center");
        this.input_fld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HTMLviewer.this.refresh_btn.doClick();
            }
        });
        this.html_panel.addHyperlinkListener(this);
        this.init_btn = null;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HTMLviewer.this.setVisible(false);
            }
        });
    }

    public HTMLviewer(String title_str, JButton button) {
        this(title_str);
        this.init_btn = button;
    }

    public void setVisible(boolean val) {
        super.setVisible(val);
        if (this.init_btn != null) {
            this.init_btn.setEnabled(!val);
        }
    }

    public void init(URL init_URL) {
        URL curr_URL = init_URL;
        if (curr_URL != null) {
            this.input_fld.setText(curr_URL.toString());
            this.refresh_btn.doClick();
        }
    }

    protected URL getURL(String filename) {
        URL url = null;
        url = this.getClass().getResource(filename);
        return url;
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        Insets btn_insets = new Insets(1, 1, 1, 1);
        Dimension small_spacer_size = new Dimension(5, 5);
        Dimension medium_spacer_size = new Dimension(10, 5);
        Dimension big_spacer_size = new Dimension(20, 5);
        URL icon_URL = this.getURL("/images/Backward24.gif");
        this.backward_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Backward");
        this.backward_btn.setMargin(btn_insets);
        this.backward_btn.setToolTipText("Go Backward one page");
        this.backward_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!HTMLviewer.this.url_undo_stack.empty()) {
                    HTMLviewer.this.updateURLStack(HTMLviewer.this.url_redo_stack);
                    URL url = (URL)HTMLviewer.this.url_undo_stack.pop();
                    HTMLviewer.this.input_fld.setText(url.toString());
                    HTMLviewer.this.refresh_btn.doClick();
                }
            }
        });
        toolbar.add(this.backward_btn);
        toolbar.addSeparator(small_spacer_size);
        icon_URL = this.getURL("/images/Forward24.gif");
        this.forward_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Forward");
        this.forward_btn.setMargin(btn_insets);
        this.forward_btn.setToolTipText("Go Forward one page");
        this.forward_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!HTMLviewer.this.url_redo_stack.empty()) {
                    HTMLviewer.this.updateURLStack(HTMLviewer.this.url_undo_stack);
                    URL url = (URL)HTMLviewer.this.url_redo_stack.pop();
                    HTMLviewer.this.input_fld.setText(url.toString());
                    HTMLviewer.this.refresh_btn.doClick();
                }
            }
        });
        toolbar.add(this.forward_btn);
        toolbar.addSeparator(medium_spacer_size);
        icon_URL = this.getURL("/images/Refresh24.gif");
        this.refresh_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Refresh");
        this.refresh_btn.setMargin(btn_insets);
        this.refresh_btn.setToolTipText("Refresh the current page");
        this.refresh_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                URL curr_URL = null;
                try {
                    curr_URL = new URL(HTMLviewer.this.input_fld.getText());
                    HTMLviewer.this.html_panel.setPage(curr_URL);
                }
                catch (IOException ioerr) {
                    Dialogs.error(HTMLviewer.this, "Invalid URL: " + curr_URL.toString());
                }
            }
        });
        toolbar.add(this.refresh_btn);
        toolbar.addSeparator(big_spacer_size);
        icon_URL = this.getURL("/images/Stop24.gif");
        this.close_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Close");
        this.close_btn.setMargin(btn_insets);
        this.close_btn.setToolTipText("Close the HTMLviewer window");
        this.close_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HTMLviewer.this.setVisible(false);
            }
        });
        toolbar.add(this.close_btn);
        return toolbar;
    }

    private void updateURLStack(Stack url_stack) {
        String url_str = this.input_fld.getText();
        if (url_str != null) {
            try {
                URL url = new URL(url_str);
                url_stack.push(url);
            }
            catch (MalformedURLException ioerr) {
                Dialogs.error(this, "Malformed URL " + url_str);
            }
        }
    }

    public void hyperlinkUpdate(final HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.html_panel.setCursor(new Cursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Document docu = HTMLviewer.this.html_panel.getDocument();
                    URL curr_URL = null;
                    try {
                        curr_URL = evt.getURL();
                        if (curr_URL != null) {
                            HTMLviewer.this.updateURLStack(HTMLviewer.this.url_undo_stack);
                            HTMLviewer.this.input_fld.setText(curr_URL.toString());
                            HTMLviewer.this.html_panel.setPage(curr_URL);
                        } else {
                            Dialogs.error(HTMLviewer.this, "Invalid Link: NULL pointer!");
                            HTMLviewer.this.html_panel.setDocument(docu);
                        }
                    }
                    catch (IOException ioerr) {
                        Dialogs.error(HTMLviewer.this, "Invalid Link: " + curr_URL.toString());
                    }
                    HTMLviewer.this.html_panel.setCursor(new Cursor(0));
                }
            });
        }
    }

    public static void main(String[] args) {
        URL init_URL = ClassLoader.getSystemResource("doc/html/index.html");
        HTMLviewer htmlview = new HTMLviewer(null);
        htmlview.init(init_URL);
        htmlview.setVisible(true);
    }
}

