/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.CategorySummary;
import base.drawable.CategoryWeight;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.DrawnBoxSet;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.topology.Line;
import base.topology.PreviewEvent;
import base.topology.PreviewState;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class Shadow
extends Primitive
implements MixedDataIO {
    private static final int BYTESIZE = 28;
    private long num_real_objs;
    private CategoryWeight[] twgt_ary;
    private Map map_type2twgt;
    private Map map_type2dobjs;
    private Set set_nestables;
    private List list_childshades;
    private Category selected_subtype;
    private int total_pixel_height;
    private static Insets Empty_Border = new Insets(0, 2, 0, 2);
    private static long Arrow_Log_Base = 10L;
    private static Stroke[] Line_Strokes = new Stroke[10];

    public Shadow() {
        this.num_real_objs = 0L;
        this.twgt_ary = null;
        this.map_type2dobjs = null;
        this.map_type2twgt = null;
        this.set_nestables = null;
        this.list_childshades = null;
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public Shadow(Shadow shade) {
        super(shade);
        this.num_real_objs = shade.num_real_objs;
        this.twgt_ary = null;
        this.map_type2twgt = new HashMap();
        this.map_type2dobjs = null;
        this.set_nestables = null;
        this.list_childshades = null;
        Iterator shade_twgts_itr = shade.map_type2twgt.values().iterator();
        while (shade_twgts_itr.hasNext()) {
            CategoryWeight shade_twgt = (CategoryWeight)shade_twgts_itr.next();
            this.map_type2twgt.put(shade_twgt.getCategory(), new CategoryWeight(shade_twgt));
        }
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public Shadow(Category shadow_type, Primitive prime) {
        super(shadow_type, prime);
        this.num_real_objs = 1L;
        this.twgt_ary = null;
        this.map_type2twgt = null;
        this.map_type2dobjs = new HashMap();
        ArrayList<Primitive> dobj_list = new ArrayList<Primitive>();
        dobj_list.add(prime);
        this.map_type2dobjs.put(prime.getCategory(), dobj_list);
        if (shadow_type.getTopology().isState()) {
            this.set_nestables = new TreeSet(Drawable.INCRE_STARTTIME_ORDER);
            this.set_nestables.add(prime);
            this.list_childshades = new ArrayList();
        } else {
            this.set_nestables = null;
            this.list_childshades = null;
        }
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public void mergeWithPrimitive(Primitive prime) {
        Coord[] shade_vtxs;
        Coord[] prime_vtxs = prime.getVertices();
        if (prime_vtxs.length != (shade_vtxs = super.getVertices()).length) {
            String err_msg = "Shadow.mergeWithPrimitive(): ERROR! Incompatible Topology between Shadow and Primitive.";
            throw new IllegalArgumentException(err_msg);
        }
        for (int idx = 0; idx < shade_vtxs.length; ++idx) {
            shade_vtxs[idx].time = Shadow.aveOverAllObjs(shade_vtxs[idx].time, this.num_real_objs, prime_vtxs[idx].time, 1L);
        }
        super.affectTimeBounds(prime);
        ++this.num_real_objs;
        ArrayList<Primitive> dobj_list = (ArrayList<Primitive>)this.map_type2dobjs.get(prime.getCategory());
        if (dobj_list == null) {
            dobj_list = new ArrayList<Primitive>();
            dobj_list.add(prime);
            this.map_type2dobjs.put(prime.getCategory(), dobj_list);
        } else {
            dobj_list.add(prime);
        }
        if (this.set_nestables != null) {
            this.set_nestables.add(prime);
        }
    }

    public void mergeWithShadow(Shadow sobj) {
        float duration_ratio;
        Coord[] shade_vtxs;
        Coord[] sobj_vtxs = sobj.getVertices();
        if (sobj_vtxs.length != (shade_vtxs = super.getVertices()).length) {
            String err_msg = "Shadow.mergeWithShadow(): ERROR! Incompatible Topology between the 2 Shadows.";
            throw new IllegalArgumentException(err_msg);
        }
        double old_duration = super.getDuration();
        for (int idx = 0; idx < shade_vtxs.length; ++idx) {
            shade_vtxs[idx].time = Shadow.aveOverAllObjs(shade_vtxs[idx].time, this.num_real_objs, sobj_vtxs[idx].time, sobj.num_real_objs);
        }
        super.affectTimeBounds(sobj);
        double new_duration = super.getDuration();
        this.num_real_objs += sobj.num_real_objs;
        if (old_duration != new_duration) {
            duration_ratio = (float)(old_duration / new_duration);
            Iterator this_twgts_itr = this.map_type2twgt.values().iterator();
            while (this_twgts_itr.hasNext()) {
                CategoryWeight this_twgt = (CategoryWeight)this_twgts_itr.next();
                this_twgt.rescaleAllRatios(duration_ratio);
            }
        }
        double sobj_duration = sobj.getDuration();
        duration_ratio = (float)(sobj_duration / new_duration);
        Iterator sobj_twgts_itr = sobj.map_type2twgt.values().iterator();
        while (sobj_twgts_itr.hasNext()) {
            CategoryWeight sobj_twgt = (CategoryWeight)sobj_twgts_itr.next();
            Category sobj_type = sobj_twgt.getCategory();
            CategoryWeight this_twgt = (CategoryWeight)this.map_type2twgt.get(sobj_type);
            if (this_twgt == null) {
                this_twgt = new CategoryWeight(sobj_twgt);
                this_twgt.rescaleAllRatios(duration_ratio);
                this.map_type2twgt.put(sobj_type, this_twgt);
                continue;
            }
            this_twgt.addDrawableCount(sobj_twgt.getDrawableCount());
            this_twgt.addAllRatios(sobj_twgt, duration_ratio);
        }
        if (this.set_nestables != null) {
            this.list_childshades.add(sobj);
        }
    }

    private void setNestingExclusion() {
        Object[] childshades = this.list_childshades.toArray();
        Stack<Drawable> nesting_stack = new Stack<Drawable>();
        Iterator dobjs_itr = this.set_nestables.iterator();
        while (dobjs_itr.hasNext()) {
            Drawable curr_dobj = (Drawable)dobjs_itr.next();
            curr_dobj.initExclusion(childshades);
            while (!nesting_stack.empty()) {
                Drawable stacked_dobj = (Drawable)nesting_stack.peek();
                if (stacked_dobj.covers(curr_dobj)) {
                    stacked_dobj.decrementExclusion(curr_dobj.getExclusion());
                    break;
                }
                nesting_stack.pop();
            }
            nesting_stack.push(curr_dobj);
        }
        nesting_stack.clear();
        this.list_childshades.clear();
        this.list_childshades = null;
        this.set_nestables.clear();
        this.set_nestables = null;
    }

    public void initializeMapOfCategoryWeights() {
        if (this.map_type2twgt == null) {
            this.map_type2twgt = new HashMap();
        }
        double shadow_duration = super.getDuration();
        Iterator type_dobjs_itr = this.map_type2dobjs.entrySet().iterator();
        while (type_dobjs_itr.hasNext()) {
            Map.Entry type_dobj = type_dobjs_itr.next();
            Category type = (Category)type_dobj.getKey();
            List dobj_list = (List)type_dobj.getValue();
            float incl_ratio = 0.0f;
            Iterator dobjs_itr = dobj_list.iterator();
            while (dobjs_itr.hasNext()) {
                Drawable dobj = (Drawable)dobjs_itr.next();
                double incl_fract = dobj.getDuration() / shadow_duration;
                incl_ratio += (float)incl_fract;
            }
            CategoryWeight twgt = new CategoryWeight(type, incl_ratio, 0.0f, dobj_list.size());
            this.map_type2twgt.put(type, twgt);
            dobj_list = null;
        }
    }

    public void finalizeMapOfCategoryWeights() {
        if (this.set_nestables != null) {
            this.setNestingExclusion();
            double shadow_duration = super.getDuration();
            Iterator type_dobjs_itr = this.map_type2dobjs.entrySet().iterator();
            while (type_dobjs_itr.hasNext()) {
                Map.Entry type_dobj = type_dobjs_itr.next();
                Category type = (Category)type_dobj.getKey();
                List dobj_list = (List)type_dobj.getValue();
                float excl_ratio = 0.0f;
                Iterator dobjs_itr = dobj_list.iterator();
                while (dobjs_itr.hasNext()) {
                    Drawable dobj = (Drawable)dobjs_itr.next();
                    double excl_fract = dobj.getExclusion() / shadow_duration;
                    excl_ratio += (float)excl_fract;
                }
                CategoryWeight twgt = (CategoryWeight)this.map_type2twgt.get(type);
                twgt.addExclusiveRatio(excl_ratio);
                dobj_list = null;
            }
        }
        if (this.map_type2dobjs != null) {
            this.map_type2dobjs.clear();
            this.map_type2dobjs = null;
        }
    }

    private static double aveOverAllObjs(double sobj_time, long sobj_Nobjs, double dobj_time, long dobj_Nobjs) {
        return (sobj_time * (double)sobj_Nobjs + dobj_time * (double)dobj_Nobjs) / (double)(sobj_Nobjs + dobj_Nobjs);
    }

    public int getByteSize() {
        if (this.twgt_ary != null) {
            return super.getByteSize() + 28 + 20 * this.twgt_ary.length;
        }
        if (this.map_type2twgt != null) {
            return super.getByteSize() + 28 + 20 * this.map_type2twgt.size();
        }
        return super.getByteSize() + 28 + 20 * this.map_type2dobjs.size();
    }

    public boolean resolveCategory(Map categorymap) {
        boolean allOK = super.resolveCategory(categorymap);
        if (this.twgt_ary != null) {
            for (int idx = this.twgt_ary.length - 1; idx >= 0; --idx) {
                allOK = allOK && this.twgt_ary[idx].resolveCategory(categorymap);
            }
        }
        return allOK;
    }

    public CategoryWeight[] arrayOfCategoryWeights() {
        return this.twgt_ary;
    }

    public Category getSelectedSubCategory() {
        return this.selected_subtype;
    }

    public void clearSelectedSubCategory() {
        this.selected_subtype = null;
    }

    public void setTotalPixelHeight(int new_height) {
        this.total_pixel_height = new_height;
    }

    public int getTotalPixelHeight() {
        return this.total_pixel_height;
    }

    public long getNumOfRealObjects() {
        return this.num_real_objs;
    }

    public void summarizeCategories(double buf4sobjs_duration) {
        float duration_ratio = (float)(super.getDuration() / buf4sobjs_duration);
        Iterator this_twgts_itr = this.map_type2twgt.values().iterator();
        while (this_twgts_itr.hasNext()) {
            CategoryWeight this_twgt = (CategoryWeight)this_twgts_itr.next();
            CategorySummary type_smy = this_twgt.getCategory().getSummary();
            type_smy.addDrawableCount(this_twgt.getDrawableCount());
            type_smy.addAllRatios(this_twgt, duration_ratio);
        }
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        super.writeObject(outs);
        TimeBoundingBox.writeObject(this, outs);
        outs.writeLong(this.num_real_objs);
        if (this.map_type2twgt.size() > 0) {
            Object[] twgts = this.map_type2twgt.values().toArray();
            Arrays.sort(twgts, CategoryWeight.INCL_RATIO_ORDER);
            int twgts_length = twgts.length;
            outs.writeInt(twgts_length);
            for (int idx = 0; idx < twgts_length; ++idx) {
                ((CategoryWeight)twgts[idx]).writeObject(outs);
            }
        } else {
            outs.writeInt(0);
        }
    }

    public Shadow(MixedDataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        super.readObject(ins);
        TimeBoundingBox.readObject(this, ins);
        this.num_real_objs = ins.readLong();
        int Nentries = ins.readInt();
        if (Nentries > 0) {
            this.twgt_ary = new CategoryWeight[Nentries];
            for (int ientry = 0; ientry < Nentries; ++ientry) {
                this.twgt_ary[ientry] = new CategoryWeight(ins);
            }
        } else {
            this.twgt_ary = null;
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer(super.toString());
        rep.append(" Nrobjs=" + this.num_real_objs);
        CategoryWeight[] twgts = null;
        if (this.twgt_ary != null) {
            twgts = this.twgt_ary;
        } else if (this.map_type2twgt != null) {
            twgts = (CategoryWeight[])this.map_type2twgt.values().toArray();
        }
        if (twgts != null) {
            int twgts_length = twgts.length;
            for (int idx = 0; idx < twgts_length; ++idx) {
                rep.append("\n" + twgts[idx]);
            }
        }
        return rep.toString();
    }

    public static void setStateInsetsDimension(int width, int height) {
        Empty_Border = new Insets(height, width, height, width);
    }

    public int drawState(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        return PreviewState.draw(g, color, this, Empty_Border, coord_xform, drawn_boxes.getLastStatePos(rowID), tStart, rStart, tFinal, rFinal);
    }

    public static void setBaseOfLogOfObjectNumToArrowWidth(int new_log_base) {
        Arrow_Log_Base = new_log_base;
    }

    private static Stroke getArrowStroke(long inum) {
        int idx;
        for (idx = 0; idx < Line_Strokes.length && (inum /= Arrow_Log_Base) != 0L; ++idx) {
        }
        if (idx < Line_Strokes.length) {
            return Line_Strokes[idx];
        }
        return Line_Strokes[Line_Strokes.length - 1];
    }

    public int drawArrow(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        int iStart = (Integer)map_line2row.get(new Integer(start_vtx.lineID));
        int iFinal = (Integer)map_line2row.get(new Integer(final_vtx.lineID));
        Stroke arrow_stroke = Shadow.getArrowStroke(this.num_real_objs);
        return Line.draw(g, color, arrow_stroke, coord_xform, drawn_boxes.getLastArrowPos(iStart, iFinal), tStart, iStart, tFinal, iFinal);
    }

    public int drawEvent(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord vtx = this.getStartVertex();
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rPeak = (float)rowID - 0.25f;
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return PreviewEvent.draw(g, color, null, coord_xform, drawn_boxes.getLastEventPos(rowID), tStart, rStart, tFinal, rFinal, tPoint, rPeak);
    }

    public boolean isPixelInState(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        this.selected_subtype = PreviewState.containsPixel(this, Empty_Border, coord_xform, pix_pt, tStart, rStart, tFinal, rFinal);
        return this.selected_subtype != null;
    }

    public boolean isPixelOnArrow(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        float rStart = ((Integer)map_line2row.get(new Integer(start_vtx.lineID))).floatValue();
        float rFinal = ((Integer)map_line2row.get(new Integer(final_vtx.lineID))).floatValue();
        return Line.containsPixel(coord_xform, pix_pt, tStart, rStart, tFinal, rFinal);
    }

    public boolean isPixelAtEvent(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord vtx = this.getStartVertex();
        double tStart = super.getEarliestTime();
        double tFinal = super.getLatestTime();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rPeak = (float)rowID - 0.25f;
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return PreviewEvent.containsPixel(coord_xform, pix_pt, tStart, rStart, tFinal, rFinal, tPoint, rPeak);
    }

    public boolean containSearchable() {
        for (int idx = this.twgt_ary.length - 1; idx >= 0; --idx) {
            CategoryWeight twgt = this.twgt_ary[idx];
            if (!twgt.getCategory().isVisiblySearchable()) continue;
            return true;
        }
        return false;
    }

    static {
        for (int idx = Line_Strokes.length - 1; idx >= 0; --idx) {
            Shadow.Line_Strokes[idx] = new BasicStroke(idx + 1);
        }
    }
}

