/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Method;

public class YCoordMap {
    private int num_rows;
    private int num_columns;
    private String title_name;
    private String[] column_names;
    private int[] map_elems;
    private Method[] methods;

    public YCoordMap(int Nrows, int Ncolumns, String title, String[] col_names, int[] ielems, int[] methodIDs) {
        this.num_rows = Nrows;
        this.num_columns = Ncolumns;
        this.title_name = title;
        this.column_names = col_names;
        this.map_elems = ielems;
        this.setMethodIDs(methodIDs);
    }

    private void setMethodIDs(int[] methodIDs) {
        if (methodIDs != null && methodIDs.length > 0) {
            this.methods = new Method[methodIDs.length];
            for (int idx = 0; idx < methodIDs.length; ++idx) {
                this.methods[idx] = new Method(methodIDs[idx]);
            }
        } else {
            this.methods = null;
        }
    }

    public void setMethods(Method[] in_methods) {
        this.methods = in_methods;
    }

    public int getNumOfRows() {
        return this.num_rows;
    }

    public int getNumOfColumns() {
        return this.num_columns;
    }

    public String getTitleName() {
        return this.title_name;
    }

    public String[] getColumnNames() {
        return this.column_names;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int[] getMapElems() {
        return this.map_elems;
    }

    public String toString() {
        int icol;
        StringBuffer rep = new StringBuffer("Title: " + this.title_name + "\n");
        rep.append("Column Labels: LineID -> ");
        int num_columns_minus_one = this.num_columns - 1;
        for (icol = 0; icol < num_columns_minus_one; ++icol) {
            rep.append(this.column_names[icol] + " ");
        }
        rep.append("\n");
        int idx = 0;
        for (int irow = 0; irow < this.num_rows; ++irow) {
            rep.append("\t" + this.map_elems[idx++] + " -> ");
            for (icol = 0; icol < num_columns_minus_one; ++icol) {
                rep.append(" " + this.map_elems[idx++]);
            }
            rep.append("\n");
        }
        if (this.methods != null && this.methods.length > 0) {
            rep.append("Methods=< ");
            for (idx = 0; idx < this.methods.length; ++idx) {
                rep.append(this.methods[idx] + " ");
            }
            rep.append(">\n");
        }
        return rep.toString();
    }
}

