/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeNodeID
implements DataIO {
    public static final int BYTESIZE = 6;
    public static final Order INCRE_INDEX_ORDER = new IncreasingIndexOrder();
    public static final Order DECRE_INDEX_ORDER = new DecreasingIndexOrder();
    public short depth;
    public int xpos;

    public TreeNodeID(short in_depth, int in_xpos) {
        this.depth = in_depth;
        this.xpos = in_xpos;
    }

    public TreeNodeID(TreeNodeID ID) {
        this.depth = ID.depth;
        this.xpos = ID.xpos;
    }

    public TreeNodeID getParentNodeID(int num_leafs) {
        return new TreeNodeID((short)(this.depth + 1), this.xpos / num_leafs);
    }

    public void toParent(int num_leafs) {
        this.depth = (short)(this.depth + 1);
        this.xpos /= num_leafs;
    }

    public void toNextSibling() {
        ++this.xpos;
    }

    public void toPreviousSibling() {
        --this.xpos;
    }

    public boolean isPossibleRoot() {
        return this.xpos == 0;
    }

    public boolean isLeaf() {
        return this.depth == 0;
    }

    public boolean equals(TreeNodeID nodeID) {
        return this.depth == nodeID.depth && this.xpos == nodeID.xpos;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeShort(this.depth);
        outs.writeInt(this.xpos);
    }

    public TreeNodeID(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.depth = ins.readShort();
        this.xpos = ins.readInt();
    }

    public String toString() {
        return "ID(" + this.depth + "," + this.xpos + ")";
    }

    public static final void main(String[] args) {
        TreeNodeID ID;
        int xp;
        int xp_max;
        short dd;
        int ll;
        int ll_max = 4;
        TreeMap<TreeNodeID, String> map = new TreeMap<TreeNodeID, String>();
        for (ll = 4; ll >= 0; ll = (int)((short)(ll - 1))) {
            dd = (short)(4 - ll);
            xp_max = (int)Math.pow(2.0, ll);
            for (xp = xp_max - 1; xp >= 0; --xp) {
                map.put(new TreeNodeID(dd, xp), new String("_" + ll + ", " + xp + "_"));
            }
        }
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            ID = (TreeNodeID)itr.next().getKey();
            if (ID.isPossibleRoot()) {
                System.out.println("\n" + ID);
                continue;
            }
            System.out.println(ID);
        }
        System.out.println("\n\n");
        TreeSet<TreeNodeID> set = new TreeSet<TreeNodeID>(INCRE_INDEX_ORDER);
        for (ll = 0; ll <= 4; ll = (int)((short)(ll + 1))) {
            dd = (short)(4 - ll);
            xp_max = (int)Math.pow(2.0, ll);
            for (xp = xp_max - 1; xp >= 0; --xp) {
                set.add(new TreeNodeID(dd, xp));
            }
        }
        itr = set.iterator();
        while (itr.hasNext()) {
            ID = (TreeNodeID)((Object)itr.next());
            if (ID.isPossibleRoot()) {
                System.out.println("\n" + ID);
                continue;
            }
            System.out.println(ID);
        }
        System.out.println("\n\n");
        set = new TreeSet(DECRE_INDEX_ORDER);
        for (ll = 0; ll <= 4; ll = (int)((short)(ll + 1))) {
            dd = (short)(4 - ll);
            xp_max = (int)Math.pow(2.0, ll);
            for (xp = xp_max - 1; xp >= 0; --xp) {
                set.add(new TreeNodeID(dd, xp));
            }
        }
        itr = set.iterator();
        while (itr.hasNext()) {
            ID = (TreeNodeID)((Object)itr.next());
            if (ID.isPossibleRoot()) {
                System.out.println(ID + "\n");
                continue;
            }
            System.out.println(ID);
        }
    }

    private static class DecreasingIndexOrder
    implements Order {
        private DecreasingIndexOrder() {
        }

        public int compare(Object o1, Object o2) {
            TreeNodeID ID1 = (TreeNodeID)o1;
            TreeNodeID ID2 = (TreeNodeID)o2;
            if (ID1.depth == ID2.depth) {
                if (ID1.xpos == ID2.xpos) {
                    return 0;
                }
                return ID1.xpos > ID2.xpos ? -1 : 1;
            }
            return ID1.depth > ID2.depth ? -1 : 1;
        }

        public boolean isIncreasingIndexOrdered() {
            return false;
        }
    }

    private static class IncreasingIndexOrder
    implements Order {
        private IncreasingIndexOrder() {
        }

        public int compare(Object o1, Object o2) {
            TreeNodeID ID1 = (TreeNodeID)o1;
            TreeNodeID ID2 = (TreeNodeID)o2;
            if (ID1.depth == ID2.depth) {
                if (ID1.xpos == ID2.xpos) {
                    return 0;
                }
                return ID1.xpos < ID2.xpos ? -1 : 1;
            }
            return ID1.depth > ID2.depth ? -1 : 1;
        }

        public boolean isIncreasingIndexOrdered() {
            return true;
        }
    }

    public static interface Order
    extends Comparator {
        public boolean isIncreasingIndexOrdered();
    }
}

