/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import base.drawable.Shadow;
import base.topology.StateBorder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;

public class PreviewState {
    private static StateBorder BorderStyle = StateBorder.COLOR_XOR_BORDER;
    public static final String FIT_MOST_LEGENDS = "FitMostLegends";
    private static final int FIT_MOST_LEGENDS_ID = 0;
    public static final String OVERLAP_INCLUSION = "OverlapInclusionRatio";
    private static final int OVERLAP_INCLUSION_ID = 1;
    public static final String CUMULATIVE_INCLUSION = "CumulativeInclusionRatio";
    private static final int CUMULATIVE_INCLUSION_ID = 2;
    public static final String OVERLAP_EXCLUSION = "OverlapExclusionRatio";
    private static final int OVERLAP_EXCLUSION_ID = 3;
    public static final String CUMULATIVE_EXCLUSION = "CumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_ID = 4;
    public static final String CUMULATIVE_EXCLUSION_BASE = "BaseAlignedCumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_BASE_ID = 5;
    private static int DisplayType = 1;
    private static int MinCategoryHeight = 2;
    private static int MinCategorySeparation = 4;

    public static void setBorderStyle(StateBorder state_border) {
        BorderStyle = state_border;
    }

    public static void setDisplayType(String new_display_type) {
        DisplayType = new_display_type.equals(FIT_MOST_LEGENDS) ? 0 : (new_display_type.equals(OVERLAP_INCLUSION) ? 1 : (new_display_type.equals(CUMULATIVE_INCLUSION) ? 2 : (new_display_type.equals(OVERLAP_EXCLUSION) ? 3 : (new_display_type.equals(CUMULATIVE_EXCLUSION) ? 4 : (new_display_type.equals(CUMULATIVE_EXCLUSION_BASE) ? 5 : 1)))));
    }

    public static void setMinCategoryHeight(int new_min_category_height) {
        MinCategoryHeight = new_min_category_height;
    }

    private static int drawForward(Graphics2D g, Color color, Shadow shade, Insets insets, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        int iDelta;
        int jDelta;
        int jLevel;
        int idx;
        boolean isInclusive;
        int iFinal;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (last_drawn_pos.coversState(iStart, iFinal = coord_xform.convertTimeToPixel(final_time))) {
            return 0;
        }
        last_drawn_pos.set(iStart, iFinal);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (insets != null) {
            iStart += insets.left;
            iFinal -= insets.right;
            jStart += insets.top;
            jFinal -= insets.bottom;
        }
        int iImageWidth = coord_xform.getImageWidth();
        boolean isStartVtxInImg = iStart >= 0;
        boolean isFinalVtxInImg = iFinal < iImageWidth;
        int iHead = isStartVtxInImg ? iStart : 0;
        int jHead = jStart;
        int iTail = isFinalVtxInImg ? iFinal : iImageWidth - 1;
        int jTail = jFinal;
        int iRange = iFinal - iStart + 1;
        int iWidth = iTail - iHead + 1;
        int jHeight = jTail - jHead + 1;
        CategoryWeight twgt = null;
        int jDeltaTotal = 0;
        CategoryWeight[] twgts = shade.arrayOfCategoryWeights();
        int twgts_length = twgts.length;
        if (DisplayType == 2 || DisplayType == 4 || DisplayType == 5) {
            float height_per_wgt;
            boolean bl = isInclusive = DisplayType == 2;
            if (isInclusive) {
                Arrays.sort(twgts, CategoryWeight.INCL_RATIO_ORDER);
                float tot_wgt = 0.0f;
                for (idx = 0; idx < twgts_length; ++idx) {
                    twgt = twgts[idx];
                    if (!twgt.getCategory().isVisible()) continue;
                    tot_wgt += twgt.getRatio(isInclusive);
                }
                height_per_wgt = (float)jHeight / tot_wgt;
            } else {
                Arrays.sort(twgts, CategoryWeight.EXCL_RATIO_ORDER);
                height_per_wgt = jHeight;
            }
            jLevel = jHead + jHeight;
            for (idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                if (twgt.getCategory().isVisible()) {
                    jDelta = (int)(height_per_wgt * twgt.getRatio(isInclusive) + 0.5f);
                    if (jDelta > 0) {
                        if (jLevel > jHead) {
                            if (jLevel - jDelta >= jHead) {
                                jLevel -= jDelta;
                                twgt.setPixelHeight(jDelta);
                            } else {
                                twgt.setPixelHeight(jLevel - jHead);
                                jLevel = jHead;
                            }
                        } else {
                            twgt.setPixelHeight(0);
                        }
                    } else {
                        twgt.setPixelHeight(0);
                    }
                } else {
                    twgt.setPixelHeight(0);
                }
                jDeltaTotal += twgt.getPixelHeight();
            }
            shade.setTotalPixelHeight(jDeltaTotal);
        } else if (DisplayType == 1 || DisplayType == 3) {
            boolean bl = isInclusive = DisplayType == 1;
            if (isInclusive) {
                Arrays.sort(twgts, CategoryWeight.INCL_RATIO_ORDER);
            } else {
                Arrays.sort(twgts, CategoryWeight.EXCL_RATIO_ORDER);
            }
            jLevel = Integer.MAX_VALUE;
            iDelta = iRange;
            for (idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                if (twgt.getCategory().isVisible()) {
                    jDelta = (int)(twgt.getRatio(isInclusive) * (float)jHeight + 0.5f);
                    twgt.setPixelHeight(jDelta);
                    if (jDelta >= jLevel) {
                        iDelta -= MinCategorySeparation;
                    }
                    twgt.setPixelWidth(iDelta);
                    jLevel = jDelta;
                    continue;
                }
                twgt.setPixelHeight(0);
            }
        } else {
            Arrays.sort(twgts, CategoryWeight.INCL_RATIO_ORDER);
            int num_visible_twgts = 0;
            for (idx = 0; idx < twgts_length; ++idx) {
                if (!twgts[idx].getCategory().isVisible()) continue;
                ++num_visible_twgts;
            }
            jDelta = (int)((float)jHeight / (float)num_visible_twgts);
            if (jDelta < MinCategoryHeight) {
                jDelta = MinCategoryHeight;
            }
            jLevel = jHead + jHeight;
            for (idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                if (twgt.getCategory().isVisible()) {
                    if (jLevel > jHead) {
                        if (jLevel - jDelta >= jHead) {
                            jLevel -= jDelta;
                            twgt.setPixelHeight(jDelta);
                            continue;
                        }
                        twgt.setPixelHeight(jLevel - jHead);
                        jLevel = jHead;
                        continue;
                    }
                    twgt.setPixelHeight(0);
                    continue;
                }
                twgt.setPixelHeight(0);
            }
        }
        int num_sub_rects_drawn = 0;
        if (DisplayType == 1 || DisplayType == 3) {
            int jCenter = jHead + jHeight / 2;
            int iCenter = iStart + iRange / 2;
            for (idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                jDelta = twgt.getPixelHeight();
                int iBoxWidth = twgt.getPixelWidth();
                if (jDelta <= 0 || iBoxWidth <= 0) continue;
                int iBoxHead = iCenter - iBoxWidth / 2;
                int iBoxTail = iBoxHead + iBoxWidth;
                int iLevel = iBoxHead >= 0 ? iBoxHead : 0;
                iDelta = (iBoxTail < iImageWidth ? iBoxTail : iImageWidth) - iLevel;
                g.setColor(twgt.getCategory().getColor());
                g.fillRect(iLevel, jCenter - jDelta / 2, iDelta, jDelta);
                ++num_sub_rects_drawn;
            }
        } else {
            jLevel = jHead + jHeight;
            if (DisplayType == 4) {
                jLevel -= (jHeight - jDeltaTotal) / 2;
            }
            for (idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                jDelta = twgt.getPixelHeight();
                if (jDelta <= 0) continue;
                g.setColor(twgt.getCategory().getColor());
                g.fillRect(iHead, jLevel -= jDelta, iWidth, jDelta);
                ++num_sub_rects_drawn;
            }
        }
        if (num_sub_rects_drawn > 0) {
            BorderStyle.paintStateBorder(g, color, iHead, jHead, isStartVtxInImg, iTail, jTail, isFinalVtxInImg);
        }
        return 1;
    }

    private static Category isPixelIn(Shadow shade, Insets insets, CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        int pt_y = pt.y;
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        if (pt_y < jStart) {
            return null;
        }
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (pt_y > jFinal) {
            return null;
        }
        int pt_x = pt.x;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (pt_x < iStart) {
            return null;
        }
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        if (pt_x > iFinal) {
            return null;
        }
        if (insets != null) {
            iStart += insets.left;
            iFinal -= insets.right;
            jStart += insets.top;
            jFinal -= insets.bottom;
        }
        int jHead = jStart;
        int jTail = jFinal;
        int jHeight = jTail - jHead + 1;
        CategoryWeight twgt = null;
        CategoryWeight[] twgts = shade.arrayOfCategoryWeights();
        int twgts_length = twgts.length;
        if (DisplayType == 1 || DisplayType == 3) {
            int iImageWidth = coord_xform.getImageWidth();
            int iRange = iFinal - iStart + 1;
            int jCenter = jHead + jHeight / 2;
            int iCenter = iStart + iRange / 2;
            for (int idx = 0; idx < twgts_length; ++idx) {
                int jLevel;
                twgt = twgts[idx];
                int jDelta = twgt.getPixelHeight();
                int iBoxWidth = twgt.getPixelWidth();
                if (jDelta <= 0 || iBoxWidth <= 0 || pt_y < (jLevel = jCenter - jDelta / 2) || pt_y >= jLevel + jDelta) continue;
                int iBoxHead = iCenter - iBoxWidth / 2;
                int iBoxTail = iBoxHead + iBoxWidth;
                int iLevel = iBoxHead >= 0 ? iBoxHead : 0;
                int iDelta = (iBoxTail < iImageWidth ? iBoxTail : iImageWidth) - iLevel;
                if (pt_x < iLevel || pt_x >= iLevel + iDelta) continue;
                return twgt.getCategory();
            }
        } else {
            int jLevel = jHead + jHeight;
            if (DisplayType == 4) {
                jLevel -= (jHeight - shade.getTotalPixelHeight()) / 2;
            }
            for (int idx = twgts_length - 1; idx >= 0; --idx) {
                twgt = twgts[idx];
                int jDelta = twgt.getPixelHeight();
                if (jDelta <= 0 || pt_y < (jLevel -= jDelta) || pt_y >= jLevel + jDelta) continue;
                return twgt.getCategory();
            }
        }
        return null;
    }

    public static int draw(Graphics2D g, Color color, Shadow shade, Insets insets, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            if (start_ypos < final_ypos) {
                return PreviewState.drawForward(g, color, shade, insets, coord_xform, last_drawn_pos, start_time, start_ypos, final_time, final_ypos);
            }
            return PreviewState.drawForward(g, color, shade, insets, coord_xform, last_drawn_pos, start_time, final_ypos, final_time, start_ypos);
        }
        if (start_ypos < final_ypos) {
            return PreviewState.drawForward(g, color, shade, insets, coord_xform, last_drawn_pos, final_time, start_ypos, start_time, final_ypos);
        }
        return PreviewState.drawForward(g, color, shade, insets, coord_xform, last_drawn_pos, final_time, final_ypos, start_time, start_ypos);
    }

    public static Category containsPixel(Shadow shade, Insets insets, CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            if (start_ypos < final_ypos) {
                return PreviewState.isPixelIn(shade, insets, coord_xform, pt, start_time, start_ypos, final_time, final_ypos);
            }
            return PreviewState.isPixelIn(shade, insets, coord_xform, pt, start_time, final_ypos, final_time, start_ypos);
        }
        if (start_ypos < final_ypos) {
            return PreviewState.isPixelIn(shade, insets, coord_xform, pt, final_time, start_ypos, start_time, final_ypos);
        }
        return PreviewState.isPixelIn(shade, insets, coord_xform, pt, final_time, final_ypos, start_time, start_ypos);
    }
}

