/*
 * Decompiled with CFR 0.152.
 */
package base.io;

import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MixedRandomAccessFile
extends RandomAccessFile
implements MixedDataOutput,
MixedDataInput {
    public MixedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
    }

    public MixedRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    public static int getStringByteSize(String str) {
        return str.length() + 2;
    }

    public void writeString(String str) throws IOException {
        byte[] bytebuf = str.getBytes();
        short strlen = (short)bytebuf.length;
        super.writeShort(strlen);
        super.write(bytebuf);
    }

    public String readString() throws IOException {
        short strlen = super.readShort();
        if (strlen > 0) {
            byte[] bytebuf = new byte[strlen];
            super.readFully(bytebuf);
            return new String(bytebuf);
        }
        return null;
    }

    public String readStringWithLimit(short max_strlen) throws IOException {
        short strlen = super.readShort();
        if (strlen > 0) {
            if (strlen > max_strlen) {
                strlen = max_strlen;
            }
            byte[] bytebuf = new byte[strlen];
            super.readFully(bytebuf);
            return new String(bytebuf);
        }
        return null;
    }

    public static final void main(String[] args) {
        MixedRandomAccessFile fin = null;
        try {
            fin = new MixedRandomAccessFile("tmpfile", "rw");
        }
        catch (IOException ferr) {
            ferr.printStackTrace();
            System.exit(1);
        }
        try {
            if (args[0].trim().equals("write")) {
                fin.writeString("SLOG 2.0.0");
            }
            if (args[0].trim().equals("read")) {
                System.out.println(fin.readString());
            }
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }
}

