/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.ViewportTime;

public class ViewportTimePanel
extends JPanel {
    private static final long serialVersionUID = 4600L;
    private ViewportTime viewport;
    private static Border border;
    private String borderTitle;
    private int borderTitleJustification;
    private int borderTitlePosition;
    private Font borderTitleFont;
    private Color borderTitleColor;

    public ViewportTimePanel(ViewportTime vport) {
        super(new BorderLayout());
        this.viewport = vport;
        super.add((Component)this.viewport, "Center");
        super.setBackground(Color.white);
        if (border == null) {
            border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        }
        this.borderTitle = null;
        this.borderTitleJustification = 0;
        this.borderTitlePosition = 0;
        this.borderTitleFont = null;
        this.borderTitleColor = null;
    }

    public static void setDefaultBorder(Border bdr) {
        border = bdr;
    }

    public void setBorderTitle(String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        if (title != null) {
            this.borderTitle = title;
            this.borderTitleJustification = titleJustification;
            this.borderTitlePosition = titlePosition;
            this.borderTitleFont = titleFont;
            this.borderTitleColor = titleColor;
        }
        this.setBorder();
    }

    private void setBorder() {
        Border tbdr = this.borderTitle != null ? BorderFactory.createTitledBorder(border, this.borderTitle, this.borderTitleJustification, this.borderTitlePosition, this.borderTitleFont, this.borderTitleColor) : border;
        super.setBorder(tbdr);
        if (this.viewport != null) {
            Insets insets = this.getInsets();
            if (Debug.isActive()) {
                Debug.println("ViewportTimePanel(): this.insets = " + insets);
            }
            Dimension min_size = Routines.correctSize(this.viewport.getMinimumSize(), insets);
            super.setMinimumSize(min_size);
            Dimension max_size = Routines.correctSize(this.viewport.getMaximumSize(), insets);
            super.setMaximumSize(max_size);
        }
    }

    public Dimension getMinimumSize() {
        Dimension min_size = super.getMinimumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): min_size = " + min_size);
        }
        return min_size;
    }

    public Dimension getMaximumSize() {
        Dimension max_size = super.getMaximumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): max_size = " + max_size);
        }
        return max_size;
    }

    public Dimension getPreferredSize() {
        Dimension pref_size = super.getPreferredSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): pref_size = " + pref_size);
        }
        return pref_size;
    }
}

