/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import viewer.common.Parameters;
import viewer.common.SwingWorker;
import viewer.zoomable.InitializableDialog;
import viewer.zoomable.SummarizableView;

public class OperationDurationPanel
extends JPanel {
    private static final long serialVersionUID = 4100L;
    private static final Component GLUE = Box.createHorizontalGlue();
    private static Border Normal_Border = null;
    private TimeBoundingBox timebox;
    private SummarizableView summarizable;
    private InitializableDialog summary_dialog;
    private Dialog root_dialog;

    public OperationDurationPanel(TimeBoundingBox times, SummarizableView summary) {
        super.setLayout(new BoxLayout(this, 1));
        this.timebox = times;
        this.summarizable = summary;
        this.summary_dialog = null;
        this.root_dialog = null;
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        super.setBorder(Normal_Border);
        JPanel stat_panel = new JPanel();
        JButton stat_btn = null;
        URL icon_URL = this.getURL("/images/Stat110x40.gif");
        if (icon_URL != null) {
            ImageIcon icon = new ImageIcon(icon_URL);
            ImageIcon icon_shaded = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
            stat_btn = new JButton(icon);
            stat_btn.setPressedIcon(icon_shaded);
            Border raised_border = BorderFactory.createRaisedBevelBorder();
            Border lowered_border = BorderFactory.createLoweredBevelBorder();
            CompoundBorder big_border = BorderFactory.createCompoundBorder(raised_border, lowered_border);
            CompoundBorder huge_border = BorderFactory.createCompoundBorder(raised_border, big_border);
            stat_btn.setBorder(huge_border);
        } else {
            stat_btn = new JButton("Sumary Statistics");
        }
        stat_btn.setMargin(new Insets(2, 2, 2, 2));
        stat_btn.setToolTipText("Summary Statistics for the selected duration, timelines & legends");
        stat_btn.addActionListener(new StatBtnActionListener());
        stat_panel.add(GLUE);
        stat_panel.add(stat_btn);
        stat_panel.add(GLUE);
        super.add(stat_panel);
    }

    private URL getURL(String filename) {
        URL url = null;
        url = this.getClass().getResource(filename);
        return url;
    }

    private void createSummaryDialog() {
        this.root_dialog = (Dialog)SwingUtilities.windowForComponent(this);
        SwingWorker create_statline_worker = new SwingWorker(){

            public Object construct() {
                OperationDurationPanel.this.summary_dialog = OperationDurationPanel.this.summarizable.createSummary(OperationDurationPanel.this.root_dialog, OperationDurationPanel.this.timebox);
                return null;
            }

            public void finished() {
                OperationDurationPanel.this.summary_dialog.pack();
                if (Parameters.AUTO_WINDOWS_LOCATION) {
                    Rectangle bounds = OperationDurationPanel.this.root_dialog.getBounds();
                    OperationDurationPanel.this.summary_dialog.setLocation(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
                }
                OperationDurationPanel.this.summary_dialog.setVisible(true);
                OperationDurationPanel.this.summary_dialog.init();
            }
        };
        create_statline_worker.start();
    }

    private class StatBtnActionListener
    implements ActionListener {
        private StatBtnActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            OperationDurationPanel.this.createSummaryDialog();
        }
    }
}

