/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import logformat.slog2.BufForObjects;
import logformat.slog2.input.TreeFloor;
import logformat.slog2.input.TreeNode;

public class TreeFloorList {
    private static final short NULL_DEPTH = -1;
    private TreeFloor[] floors;
    private Drawable.Order dobj_order;
    private BufForObjects.Order buf4objs_order;
    private short lowest_depth;

    public TreeFloorList(Drawable.Order in_dobj_order) {
        this.dobj_order = in_dobj_order;
        this.buf4objs_order = this.dobj_order.isIncreasingTimeOrdered() ? BufForObjects.INCRE_INDEX_ORDER : BufForObjects.DECRE_INDEX_ORDER;
        this.lowest_depth = (short)-1;
        this.floors = null;
    }

    protected void init(short depth_max) {
        this.floors = new TreeFloor[depth_max + 1];
        for (int idx = this.floors.length - 1; idx >= 0; --idx) {
            this.floors[idx] = new TreeFloor((short)idx, this.buf4objs_order);
        }
        this.lowest_depth = depth_max;
    }

    public BufForObjects getRoot() {
        if (this.floors != null) {
            return (BufForObjects)this.floors[this.floors.length - 1].firstKey();
        }
        return null;
    }

    public void put(BufForObjects nodestub, BufForObjects node) {
        short node_depth = nodestub.getTreeNodeID().depth;
        this.floors[node_depth].put(nodestub, node);
        if (node_depth < this.lowest_depth) {
            this.lowest_depth = node_depth;
        }
    }

    public TreeNode get(BufForObjects nodestub) {
        short node_depth = nodestub.getTreeNodeID().depth;
        if (this.floors[node_depth].size() == 0) {
            return null;
        }
        return (TreeNode)this.floors[node_depth].get(nodestub);
    }

    public boolean contains(BufForObjects nodestub) {
        short node_depth = nodestub.getTreeNodeID().depth;
        if (this.floors[node_depth].size() == 0) {
            return false;
        }
        return this.floors[node_depth].containsKey(nodestub);
    }

    public void remove(BufForObjects nodestub) {
        short node_depth = nodestub.getTreeNodeID().depth;
        if (this.floors[node_depth].size() > 0) {
            this.floors[node_depth].remove(nodestub);
        }
    }

    public void updateLowestDepth() {
        for (int idx = 0; idx < this.floors.length; idx = (int)((short)(idx + 1))) {
            if (this.floors[idx].size() <= 0) continue;
            this.lowest_depth = (short)idx;
            break;
        }
    }

    public short getLowestDepth() {
        return this.lowest_depth;
    }

    public void removeAllChildFloorsBelow(short floor_depth) {
        for (short idepth = 0; idepth < floor_depth; idepth = (short)(idepth + 1)) {
            if (this.floors[idepth].size() <= 0) continue;
            this.floors[idepth].clear();
        }
        this.lowest_depth = floor_depth;
    }

    public TreeFloor getLowestFloor() {
        return this.floors[this.lowest_depth];
    }

    public TreeFloor getCoveringFloor(TimeBoundingBox tframe) {
        for (int idepth = this.lowest_depth; idepth < this.floors.length; ++idepth) {
            if (!this.floors[idepth].covers(tframe)) continue;
            return this.floors[idepth];
        }
        return this.floors[this.floors.length - 1];
    }

    public TreeFloor pruneToBarelyCoveringFloor(TimeBoundingBox tframe) {
        for (int idepth = this.lowest_depth; idepth < this.floors.length; ++idepth) {
            if (this.floors[idepth].coversBarely(tframe)) {
                return this.floors[idepth];
            }
            this.floors[idepth].pruneToBarelyCovering(tframe);
        }
        return this.floors[this.floors.length - 1];
    }

    public Iterator iteratorOfAllDrawables(TimeBoundingBox tframe, Drawable.Order itrOrder, boolean isComposite, boolean isNestable) {
        if (itrOrder.isStartTimeOrdered() == this.dobj_order.isStartTimeOrdered()) {
            return new ItrOfDrawables(tframe, itrOrder, isComposite, isNestable, true);
        }
        System.err.println("TreeFloorList.iteratorOfAllDrawables(): Inconsistent Start/Final TimeOrder!\nTreeFloor is created with " + this.dobj_order + "\n" + "but iteratorOfAllDrawables() is " + "invoked with " + itrOrder + ".");
        return null;
    }

    public Iterator iteratorOfRealDrawables(TimeBoundingBox tframe, Drawable.Order itrOrder, boolean isComposite, boolean isNestable) {
        if (itrOrder.isStartTimeOrdered() == this.dobj_order.isStartTimeOrdered()) {
            return new ItrOfDrawables(tframe, itrOrder, isComposite, isNestable, false);
        }
        System.err.println("TreeFloorList.iteratorOfRealDrawables(): Inconsistent Start/Final Time Order!\nTreeFloor is created with " + this.dobj_order + "\n" + "but iteratorOfRealDrawables() is " + "invoked with " + itrOrder + ".");
        return null;
    }

    public Iterator iteratorOfLowestFloorShadows(TimeBoundingBox tframe, Drawable.Order itrOrder, boolean isNestable) {
        if (itrOrder.isStartTimeOrdered() == this.dobj_order.isStartTimeOrdered()) {
            return this.floors[this.lowest_depth].iteratorOfShadows(tframe, itrOrder, isNestable);
        }
        System.err.println("TreeFloorList.iteratorOfLowestFloorShadows(): Inconsistent Start/Final TimeOrder!\nTreeFloor is created with " + this.dobj_order + "\n" + "but iteratorOfLowestFloorShadows() is " + "invoked with " + itrOrder + ".");
        return null;
    }

    public String toStubString() {
        StringBuffer rep = new StringBuffer();
        for (int idx = this.floors.length - 1; idx >= 0; --idx) {
            rep.append(this.floors[idx].toStubString() + "\n");
        }
        return rep.toString();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        for (int idx = this.floors.length - 1; idx >= 0; --idx) {
            rep.append("\n" + this.floors[idx].toStubString() + "\n");
            rep.append(this.floors[idx].toString() + "\n");
        }
        return rep.toString();
    }

    public String toString(TimeBoundingBox tframe) {
        Drawable.Order dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        boolean isComposite = true;
        StringBuffer rep = new StringBuffer();
        Iterator dobjs = this.iteratorOfRealDrawables(tframe, dobj_order, isComposite, true);
        int idx = 1;
        while (dobjs.hasNext()) {
            rep.append(idx + ", " + dobjs.next() + "\n");
            ++idx;
        }
        dobjs = this.iteratorOfRealDrawables(tframe, dobj_order, isComposite, false);
        while (dobjs.hasNext()) {
            rep.append(idx + ", " + dobjs.next() + "\n");
            ++idx;
        }
        Iterator sobjs = this.iteratorOfLowestFloorShadows(tframe, dobj_order, true);
        idx = 1;
        while (sobjs.hasNext()) {
            rep.append(idx + ", " + sobjs.next() + "\n");
            ++idx;
        }
        sobjs = this.iteratorOfLowestFloorShadows(tframe, dobj_order, false);
        while (sobjs.hasNext()) {
            rep.append(idx + ", " + sobjs.next() + "\n");
            ++idx;
        }
        return rep.toString();
    }

    public String toFloorString(TimeBoundingBox timeframe) {
        Drawable.Order dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        boolean isComposite = true;
        boolean isNestable = true;
        StringBuffer rep = new StringBuffer();
        for (int flr = this.floors.length - 1; flr >= 0; --flr) {
            rep.append("\n" + this.floors[flr].toStubString() + "\n");
            Iterator dobjs = this.floors[flr].iteratorOfDrawables(timeframe, dobj_order, isComposite, isNestable);
            int idx = 1;
            while (dobjs.hasNext()) {
                rep.append("    " + idx + ", " + dobjs.next() + "\n");
                ++idx;
            }
        }
        return rep.toString();
    }

    private class ItrOfDrawables
    implements Iterator {
        private TreeMap map_obj2itr;
        private Drawable this_floor_obj;
        private Iterator this_floor_itr;
        private Drawable next_floor_obj;
        private double next_floor_bordertime;
        private boolean isIncreTimeOrdered;
        private boolean isStartTimeOrdered;

        public ItrOfDrawables(TimeBoundingBox tframe, Drawable.Order dobj_order, boolean isComposite, boolean isNestable, boolean withShadows) {
            this.isIncreTimeOrdered = dobj_order.isIncreasingTimeOrdered();
            this.isStartTimeOrdered = dobj_order.isStartTimeOrdered();
            this.map_obj2itr = new TreeMap(dobj_order);
            for (int idx = TreeFloorList.this.floors.length - 1; idx >= TreeFloorList.this.lowest_depth; --idx) {
                this.this_floor_itr = TreeFloorList.this.floors[idx].iteratorOfDrawables(tframe, dobj_order, isComposite, isNestable);
                if (!this.this_floor_itr.hasNext()) continue;
                this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
            }
            if (withShadows) {
                this.this_floor_itr = TreeFloorList.this.floors[TreeFloorList.this.lowest_depth].iteratorOfShadows(tframe, dobj_order, isNestable);
                if (this.this_floor_itr.hasNext()) {
                    this.this_floor_obj = (Shadow)this.this_floor_itr.next();
                    this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                }
            }
            try {
                this.this_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
            }
            catch (NoSuchElementException err) {
                this.this_floor_obj = null;
                this.this_floor_itr = null;
                this.next_floor_obj = null;
                this.next_floor_bordertime = this.isIncreTimeOrdered ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            try {
                this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                this.next_floor_bordertime = this.next_floor_obj.getBorderTime(this.isStartTimeOrdered);
            }
            catch (NoSuchElementException err) {
                this.next_floor_obj = null;
                this.next_floor_bordertime = this.isIncreTimeOrdered ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }

        public boolean hasNext() {
            return this.this_floor_obj != null;
        }

        public Object next() {
            Drawable next_drawable = this.this_floor_obj;
            this.this_floor_obj = null;
            try {
                if (this.this_floor_itr.hasNext()) {
                    boolean isOK;
                    boolean isFore;
                    this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                    boolean bl = isFore = this.next_floor_bordertime < this.this_floor_obj.getBorderTime(this.isStartTimeOrdered);
                    boolean bl2 = this.isIncreTimeOrdered ? isFore : (isOK = !isFore);
                    if (isOK) {
                        Iterator next_floor_itr = (Iterator)this.map_obj2itr.remove(this.next_floor_obj);
                        this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                        this.this_floor_obj = this.next_floor_obj;
                        this.this_floor_itr = next_floor_itr;
                        this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                        this.next_floor_bordertime = this.next_floor_obj.getBorderTime(this.isStartTimeOrdered);
                    }
                } else {
                    this.this_floor_obj = this.next_floor_obj;
                    if (this.this_floor_obj != null) {
                        this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
                        this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                        this.next_floor_bordertime = this.next_floor_obj.getBorderTime(this.isStartTimeOrdered);
                    }
                }
            }
            catch (NoSuchElementException err) {
                this.next_floor_obj = null;
                this.next_floor_bordertime = this.isIncreTimeOrdered ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            return next_drawable;
        }

        public void remove() {
        }
    }
}

