/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.CategoryTimeBox;
import base.statistics.CategoryWeightF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class TimeAveBox
extends TimeBoundingBox {
    private Map map_type2twgf = new HashMap();
    private List list_nestables;
    private SortedSet set_timeblocks;
    private CategoryTimeBox[] typebox_ary = null;
    private double num_real_objs = 0.0;
    private double box_duration = super.getDuration();
    private TimeBoundingBox curr_timebox = null;

    public TimeAveBox(TimeBoundingBox timebox, boolean isNestable) {
        super(timebox);
        if (isNestable) {
            this.list_nestables = new ArrayList();
            this.set_timeblocks = new TreeSet(TimeBoundingBox.INCRE_STARTTIME_ORDER);
        } else {
            this.list_nestables = null;
            this.set_timeblocks = null;
        }
    }

    public TimeAveBox(TimeAveBox avebox) {
        this(avebox, avebox.list_nestables != null);
        this.mergeWithTimeAveBox(avebox);
    }

    public void mergeWithReal(Drawable dobj) {
        double overlap_duration = super.getIntersectionDuration(dobj);
        float box_overlap_ratio = (float)(overlap_duration / this.box_duration);
        double ave_num_real_objs = overlap_duration / dobj.getDuration() * (double)dobj.getNumOfPrimitives();
        Category type = dobj.getCategory();
        CategoryWeightF twgf = (CategoryWeightF)this.map_type2twgf.get(type);
        if (twgf == null) {
            twgf = new CategoryWeightF(type, box_overlap_ratio, 0.0f, ave_num_real_objs);
            this.map_type2twgf.put(type, twgf);
        } else {
            twgf.addDrawableCount(ave_num_real_objs);
            twgf.addInclusiveRatio(box_overlap_ratio);
        }
        this.num_real_objs += ave_num_real_objs;
        if (this.list_nestables != null) {
            this.list_nestables.add(dobj);
        }
    }

    public void mergeWithShadow(Shadow shade) {
        double overlap_duration = super.getIntersectionDuration(shade);
        float box_overlap_ratio = (float)(overlap_duration / this.box_duration);
        double sobj_overlap_ratio = overlap_duration / shade.getDuration();
        double ave_num_real_objs = sobj_overlap_ratio * (double)shade.getNumOfRealObjects();
        CategoryWeight[] sobj_twgts = shade.arrayOfCategoryWeights();
        for (int idx = sobj_twgts.length - 1; idx >= 0; --idx) {
            CategoryWeight sobj_twgt = sobj_twgts[idx];
            Category sobj_type = sobj_twgt.getCategory();
            CategoryWeightF this_twgf = (CategoryWeightF)this.map_type2twgf.get(sobj_type);
            if (this_twgf == null) {
                this_twgf = new CategoryWeightF(sobj_twgt);
                this_twgf.rescaleAllRatios(box_overlap_ratio);
                this_twgf.rescaleDrawableCount(sobj_overlap_ratio);
                this.map_type2twgf.put(sobj_type, this_twgf);
                continue;
            }
            this_twgf.addDrawableCount(sobj_overlap_ratio * (double)sobj_twgt.getDrawableCount());
            this_twgf.addAllRatios(sobj_twgt, box_overlap_ratio);
        }
        this.num_real_objs += ave_num_real_objs;
        if (this.list_nestables != null) {
            this.set_timeblocks.add(shade);
        }
    }

    public void mergeWithTimeAveBox(TimeAveBox avebox) {
        double overlap_duration = super.getIntersectionDuration(avebox);
        float box_overlap_ratio = (float)(overlap_duration / this.box_duration);
        double abox_overlap_ratio = overlap_duration / avebox.getDuration();
        double ave_num_real_objs = abox_overlap_ratio * avebox.num_real_objs;
        Iterator abox_twgfs = avebox.map_type2twgf.values().iterator();
        while (abox_twgfs.hasNext()) {
            CategoryWeightF abox_twgf = (CategoryWeightF)abox_twgfs.next();
            Category abox_type = abox_twgf.getCategory();
            CategoryWeightF this_twgf = (CategoryWeightF)this.map_type2twgf.get(abox_type);
            if (this_twgf == null) {
                this_twgf = new CategoryWeightF(abox_twgf);
                this_twgf.rescaleAllRatios(box_overlap_ratio);
                this_twgf.rescaleDrawableCount(abox_overlap_ratio);
                this.map_type2twgf.put(abox_type, this_twgf);
                continue;
            }
            this_twgf.addDrawableCount(abox_overlap_ratio * abox_twgf.getDrawableCount());
            this_twgf.addAllRatios(abox_twgf, box_overlap_ratio);
        }
        this.num_real_objs += ave_num_real_objs;
        if (this.list_nestables != null) {
            this.set_timeblocks.add(avebox);
        }
    }

    private void patchSetOfTimeBlocks() {
        TimeBoundingBox new_timeblock = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox first_timeblock = null;
        if (!this.set_timeblocks.isEmpty()) {
            first_timeblock = (TimeBoundingBox)this.set_timeblocks.first();
        }
        if (first_timeblock != null && first_timeblock.contains(super.getEarliestTime())) {
            new_timeblock.setLatestTime(first_timeblock.getEarliestTime());
        } else {
            new_timeblock.setLatestTime(super.getEarliestTime());
        }
        this.set_timeblocks.add(new_timeblock);
        new_timeblock = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox last_timeblock = null;
        if (!this.set_timeblocks.isEmpty()) {
            last_timeblock = (TimeBoundingBox)this.set_timeblocks.last();
        }
        if (last_timeblock != null && last_timeblock.contains(super.getLatestTime())) {
            new_timeblock.setEarliestTime(last_timeblock.getLatestTime());
        } else {
            new_timeblock.setEarliestTime(super.getLatestTime());
        }
        this.set_timeblocks.add(new_timeblock);
    }

    private void setRealDrawableExclusion() {
        Object[] timeblocks = this.set_timeblocks.toArray();
        Stack<Drawable> nesting_stack = new Stack<Drawable>();
        Iterator dobjs_itr = this.list_nestables.iterator();
        while (dobjs_itr.hasNext()) {
            Drawable curr_dobj = (Drawable)dobjs_itr.next();
            curr_dobj.initExclusion(timeblocks);
            while (!nesting_stack.empty()) {
                Drawable stacked_dobj = (Drawable)nesting_stack.peek();
                if (stacked_dobj.covers(curr_dobj)) {
                    stacked_dobj.decrementExclusion(curr_dobj.getExclusion());
                    break;
                }
                nesting_stack.pop();
            }
            nesting_stack.push(curr_dobj);
        }
        nesting_stack.clear();
        nesting_stack = null;
        timeblocks = null;
        this.set_timeblocks.clear();
        this.set_timeblocks = null;
    }

    private void adjustMapOfCategoryWeightFs() {
        Iterator dobjs_itr = this.list_nestables.iterator();
        while (dobjs_itr.hasNext()) {
            Drawable curr_dobj = (Drawable)dobjs_itr.next();
            float excl_ratio = (float)(curr_dobj.getExclusion() / this.box_duration);
            Category dobj_type = curr_dobj.getCategory();
            CategoryWeightF dobj_twgf = (CategoryWeightF)this.map_type2twgf.get(dobj_type);
            dobj_twgf.addExclusiveRatio(excl_ratio);
        }
        this.list_nestables.clear();
    }

    public void setNestingExclusion() {
        this.patchSetOfTimeBlocks();
        this.setRealDrawableExclusion();
        this.adjustMapOfCategoryWeightFs();
    }

    public double getAveNumOfRealObjects() {
        return this.num_real_objs;
    }

    public void initializeCategoryTimeBoxes() {
        if (this.typebox_ary == null) {
            this.typebox_ary = new CategoryTimeBox[this.map_type2twgf.size()];
            int idx = 0;
            Iterator twgfs_itr = this.map_type2twgf.values().iterator();
            while (twgfs_itr.hasNext()) {
                CategoryTimeBox typebox;
                CategoryWeightF twgf = (CategoryWeightF)twgfs_itr.next();
                this.typebox_ary[idx] = typebox = new CategoryTimeBox(twgf);
                ++idx;
            }
        }
    }

    public CategoryTimeBox[] arrayOfCategoryTimeBoxes() {
        return this.typebox_ary;
    }

    public TimeBoundingBox getCurrentTimeBoundingBox() {
        if (this.curr_timebox == null) {
            this.curr_timebox = new TimeBoundingBox();
        }
        return this.curr_timebox;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer(super.toString());
        rep.append(" Nrobjs=" + (float)this.num_real_objs);
        if (this.map_type2twgf.size() > 0) {
            CategoryWeightF[] twgfs = this.map_type2twgf.values().toArray(new CategoryWeightF[0]);
            Arrays.sort(twgfs, CategoryWeightF.INCL_RATIO_ORDER);
            int twgfs_length = twgfs.length;
            for (int idx = 0; idx < twgfs_length; ++idx) {
                rep.append("\n" + twgfs[idx]);
            }
            rep.append("\n");
        }
        return rep.toString();
    }
}

