/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.DrawnBox;
import base.drawable.DrawnBoxSet;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.topology.Arrow;
import base.topology.Event;
import base.topology.Line;
import base.topology.State;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Primitive
extends Drawable
implements MixedDataIO {
    private static final int INIT_BYTESIZE = 2;
    private Coord[] vertices;
    private int last_vtx_idx;

    public Primitive() {
        this.vertices = null;
    }

    public Primitive(int Nvertices) {
        this.vertices = new Coord[Nvertices];
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Category in_type, int Nvertices) {
        super(in_type);
        this.vertices = new Coord[Nvertices];
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Primitive prime) {
        super(prime);
        Coord[] prime_vtxs = prime.vertices;
        this.vertices = new Coord[prime_vtxs.length];
        for (int idx = 0; idx < this.vertices.length; ++idx) {
            this.vertices[idx] = new Coord(prime_vtxs[idx]);
        }
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Category in_type, Primitive prime) {
        super(in_type, prime);
        Coord[] prime_vtxs = prime.vertices;
        this.vertices = new Coord[prime_vtxs.length];
        for (int idx = 0; idx < this.vertices.length; ++idx) {
            this.vertices[idx] = new Coord(prime_vtxs[idx]);
        }
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(int type_idx, double starttime, double endtime, double[] time_coords, int[] y_coords, byte[] byte_infovals) {
        super(type_idx, byte_infovals);
        super.setEarliestTime(starttime);
        super.setLatestTime(endtime);
        int time_coords_length = time_coords.length;
        this.vertices = new Coord[time_coords_length];
        if (time_coords_length == y_coords.length) {
            for (int idx = 0; idx < time_coords_length; ++idx) {
                this.vertices[idx] = new Coord(time_coords[idx], y_coords[idx]);
            }
        } else {
            for (int idx = 0; idx < time_coords_length; ++idx) {
                this.vertices[idx] = new Coord(time_coords[idx], y_coords[idx / 2]);
            }
        }
    }

    public int getNumOfPrimitives() {
        return 1;
    }

    public int getByteSize() {
        int bytesize = super.getByteSize() + 2;
        if (this.vertices != null && this.vertices.length > 0) {
            bytesize += this.vertices.length * 12;
        }
        return bytesize;
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        super.writeObject(outs);
        int vertices_length = this.vertices.length;
        outs.writeShort(vertices_length);
        for (int idx = 0; idx < vertices_length; ++idx) {
            this.vertices[idx].writeObject(outs);
        }
    }

    public Primitive(MixedDataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        super.readObject(ins);
        short Nvertices = ins.readShort();
        this.vertices = new Coord[Nvertices];
        for (int idx = 0; idx < this.vertices.length; idx = (int)((short)(idx + 1))) {
            this.vertices[idx] = new Coord(ins);
        }
        this.last_vtx_idx = this.vertices.length - 1;
        super.affectTimeBounds(this.vertices);
    }

    public void setVertex(int vertex_idx, Coord vertex) throws ArrayIndexOutOfBoundsException {
        if (vertex_idx < 0 || vertex_idx >= this.vertices.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + vertex_idx + ", is out of range, [0.." + this.vertices.length + "].");
        }
        this.vertices[vertex_idx] = vertex;
        super.affectTimeBounds(vertex);
    }

    public Coord getVertex(int vertex_idx) throws ArrayIndexOutOfBoundsException {
        if (vertex_idx < 0 || vertex_idx >= this.vertices.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + vertex_idx + ", is out of range, [0.." + this.vertices.length + "].");
        }
        return this.vertices[vertex_idx];
    }

    public void setVertices(Coord[] in_vertices) throws IllegalArgumentException {
        if (in_vertices.length != this.vertices.length) {
            throw new IllegalArgumentException("input array size, " + in_vertices.length + ", is " + "different from the original, " + this.vertices.length);
        }
        this.vertices = in_vertices;
        super.affectTimeBounds(this.vertices);
    }

    public Coord[] getVertices() {
        return this.vertices;
    }

    public List getListOfVertexLineIDs() {
        ArrayList<Integer> lineIDs = new ArrayList<Integer>(this.vertices.length);
        for (int idx = 0; idx < this.vertices.length; ++idx) {
            lineIDs.add(new Integer(this.vertices[idx].lineID));
        }
        return lineIDs;
    }

    public Integer[] getArrayOfLineIDs() {
        Integer[] lineIDs = new Integer[this.vertices.length];
        for (int idx = 0; idx < this.vertices.length; ++idx) {
            lineIDs[idx] = new Integer(this.vertices[idx].lineID);
        }
        return lineIDs;
    }

    public void setStartVertex(Coord start_vtx) {
        this.vertices[0] = start_vtx;
        super.affectTimeBounds(start_vtx);
    }

    public void setFinalVertex(Coord final_vtx) {
        this.vertices[this.last_vtx_idx] = final_vtx;
        super.affectTimeBounds(final_vtx);
    }

    public Coord getStartVertex() {
        return this.vertices[0];
    }

    public Coord getFinalVertex() {
        return this.vertices[this.last_vtx_idx];
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("Primitive[ " + super.toString() + " ");
        for (int idx = 0; idx < this.vertices.length; ++idx) {
            rep.append(this.vertices[idx].toString() + " ");
        }
        rep.append("]");
        rep.append(" bsize=" + this.getByteSize());
        return rep.toString();
    }

    public boolean isTimeOrdered() {
        if (!super.isTimeOrdered()) {
            System.err.println("**** Violation of Causality ****\nOffending Primitive -> " + this);
            return false;
        }
        for (int idx = 0; idx <= this.last_vtx_idx; ++idx) {
            if (super.contains(this.vertices[idx].time)) continue;
            System.err.println("**** Out of Primitive Time Range ****\nOffending Primitive -> " + this + "\n" + "\t time coordinate " + idx + " is out of range.");
            return false;
        }
        return true;
    }

    public int drawState(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        return State.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastStatePos(rowID), (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public int drawArrow(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int iStart = (Integer)map_line2row.get(new Integer(start_vtx.lineID));
        int iFinal = (Integer)map_line2row.get(new Integer(final_vtx.lineID));
        return Arrow.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastArrowPos(iStart, iFinal), (double)tStart, (float)iStart, (double)tFinal, (float)iFinal);
    }

    public int drawEvent(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes, ColorAlpha color) {
        Coord vtx = this.getStartVertex();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rPeak = (float)rowID - 0.25f;
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return Event.draw((Graphics2D)g, (Color)color, null, (CoordPixelXform)coord_xform, (DrawnBox)drawn_boxes.getLastEventPos(rowID), (double)tPoint, (float)rPeak, (float)rStart, (float)rFinal);
    }

    public boolean isPixelInState(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        int rowID = super.getRowID();
        float nesting_ftr = super.getNestingFactor();
        float rStart = (float)rowID - nesting_ftr / 2.0f;
        float rFinal = rStart + nesting_ftr;
        return State.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public boolean isPixelOnArrow(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord start_vtx = this.getStartVertex();
        Coord final_vtx = this.getFinalVertex();
        double tStart = start_vtx.time;
        double tFinal = final_vtx.time;
        float rStart = ((Integer)map_line2row.get(new Integer(start_vtx.lineID))).floatValue();
        float rFinal = ((Integer)map_line2row.get(new Integer(final_vtx.lineID))).floatValue();
        return Line.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tStart, (float)rStart, (double)tFinal, (float)rFinal);
    }

    public boolean isPixelAtEvent(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Coord vtx = this.getStartVertex();
        double tPoint = vtx.time;
        int rowID = (Integer)map_line2row.get(new Integer(vtx.lineID));
        float rStart = (float)rowID - 0.5f;
        float rFinal = rStart + 1.0f;
        return Event.containsPixel((CoordPixelXform)coord_xform, (Point)pix_pt, (double)tPoint, (float)rStart, (float)rFinal);
    }

    public boolean containSearchable() {
        return super.getCategory().isVisiblySearchable();
    }
}

