/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.DrawnBoxSet;
import base.drawable.InfoBox;
import base.drawable.NestingStacks;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;

public abstract class Drawable
extends InfoBox {
    public static final float NON_NESTABLE = 1.0f;
    public static final int INVALID_ROW = Integer.MIN_VALUE;
    public static final Order INCRE_STARTTIME_ORDER = new Order(TimeBoundingBox.INCRE_STARTTIME_ORDER);
    public static final Order INCRE_FINALTIME_ORDER = new Order(TimeBoundingBox.INCRE_FINALTIME_ORDER);
    public static final Order DECRE_STARTTIME_ORDER = new Order(TimeBoundingBox.DECRE_STARTTIME_ORDER);
    public static final Order DECRE_FINALTIME_ORDER = new Order(TimeBoundingBox.DECRE_FINALTIME_ORDER);
    private double exclusion;
    private float nesting_ftr;
    private int row_ID;
    private Drawable parent;

    public Drawable() {
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Category in_type) {
        super(in_type);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Drawable dobj) {
        super(dobj);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = dobj.parent;
    }

    public Drawable(Category in_type, Drawable dobj) {
        super(in_type, dobj);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = dobj.parent;
    }

    public Drawable(int in_type_idx, byte[] byte_infovals) {
        super(in_type_idx);
        super.setInfoBuffer(byte_infovals);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public void initExclusion(Object[] childshades) {
        this.exclusion = super.getDuration();
        for (int idx = childshades.length - 1; idx >= 0; --idx) {
            this.exclusion -= super.getIntersectionDuration((TimeBoundingBox)childshades[idx]);
        }
    }

    public void decrementExclusion(double decre) {
        this.exclusion -= decre;
    }

    public double getExclusion() {
        return this.exclusion;
    }

    public boolean isNestingFactorUninitialized() {
        return this.nesting_ftr == 1.0f;
    }

    public void setNestingFactor(float new_nesting_ftr) {
        this.nesting_ftr = new_nesting_ftr;
    }

    public float getNestingFactor() {
        return this.nesting_ftr;
    }

    public boolean isRowIDUninitialized() {
        return this.row_ID == Integer.MIN_VALUE;
    }

    public void setRowID(int new_rowID) {
        this.row_ID = new_rowID;
    }

    public int getRowID() {
        return this.row_ID;
    }

    public void setParent(Drawable dobj) {
        this.parent = dobj;
    }

    public Drawable getParent() {
        return this.parent;
    }

    public abstract int getNumOfPrimitives();

    public abstract Integer[] getArrayOfLineIDs();

    public abstract Coord getStartVertex();

    public abstract Coord getFinalVertex();

    public abstract int drawState(Graphics2D var1, CoordPixelXform var2, Map var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract int drawArrow(Graphics2D var1, CoordPixelXform var2, Map var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract int drawEvent(Graphics2D var1, CoordPixelXform var2, Map var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract boolean isPixelInState(CoordPixelXform var1, Map var2, Point var3);

    public abstract boolean isPixelOnArrow(CoordPixelXform var1, Map var2, Point var3);

    public abstract boolean isPixelAtEvent(CoordPixelXform var1, Map var2, Point var3);

    public abstract boolean containSearchable();

    public void setStateRowAndNesting(CoordPixelXform coord_xform, Map map_line2row, NestingStacks nesting_stacks) {
        Coord start_vtx = this.getStartVertex();
        this.row_ID = (Integer)map_line2row.get(new Integer(start_vtx.lineID));
        this.nesting_ftr = nesting_stacks.getNestingFactorFor(this);
    }

    public int drawOnCanvas(Graphics2D g, CoordPixelXform coord_xform, Map map_line2row, DrawnBoxSet drawn_boxes) {
        Category type = super.getCategory();
        Topology topo = type.getTopology();
        if (topo.isEvent()) {
            return this.drawEvent(g, coord_xform, map_line2row, drawn_boxes, type.getColor());
        }
        if (topo.isState()) {
            return this.drawState(g, coord_xform, map_line2row, drawn_boxes, type.getColor());
        }
        if (topo.isArrow()) {
            return this.drawArrow(g, coord_xform, map_line2row, drawn_boxes, type.getColor());
        }
        System.err.println("Non-recognized Primitive type! " + this);
        return 0;
    }

    public Drawable getDrawableAt(CoordPixelXform coord_xform, Map map_line2row, Point pix_pt) {
        Category type = super.getCategory();
        Topology topo = type.getTopology();
        if (topo.isEvent()) {
            if (this.isPixelAtEvent(coord_xform, map_line2row, pix_pt)) {
                return this;
            }
        } else if (topo.isState()) {
            if (this.isPixelInState(coord_xform, map_line2row, pix_pt)) {
                return this;
            }
        } else if (topo.isArrow()) {
            if (this.isPixelOnArrow(coord_xform, map_line2row, pix_pt)) {
                return this;
            }
        } else {
            System.err.println("Non-recognized Primitive type! " + this);
        }
        return null;
    }

    public static class Order
    implements TimeBoundingBox.Order {
        private TimeBoundingBox.Order timebox_order;

        public Order(TimeBoundingBox.Order tbox_order) {
            this.timebox_order = tbox_order;
        }

        public TimeBoundingBox.Order getTimeBoundingBoxOrder() {
            return this.timebox_order;
        }

        public boolean isIncreasingTimeOrdered() {
            return this.timebox_order.isIncreasingTimeOrdered();
        }

        public boolean isStartTimeOrdered() {
            return this.timebox_order.isStartTimeOrdered();
        }

        public String toString() {
            return "Drawable." + ((Object)this.timebox_order).toString();
        }

        public int compare(Object o1, Object o2) {
            int dobj2_typeidx;
            Drawable dobj1 = (Drawable)o1;
            Drawable dobj2 = (Drawable)o2;
            int dobj_time_order = this.timebox_order.compare(dobj1, dobj2);
            if (dobj_time_order != 0) {
                return dobj_time_order;
            }
            if (dobj1 == dobj2) {
                return 0;
            }
            int dobj1_typeidx = dobj1.getCategoryIndex();
            if (dobj1_typeidx != (dobj2_typeidx = dobj2.getCategoryIndex())) {
                return dobj1_typeidx - dobj2_typeidx;
            }
            int dobj1_lineID = dobj1.getStartVertex().lineID;
            int dobj2_lineID = dobj2.getStartVertex().lineID;
            if (dobj1_lineID != dobj2_lineID) {
                return dobj1_lineID - dobj2_lineID;
            }
            dobj1_lineID = dobj1.getFinalVertex().lineID;
            dobj2_lineID = dobj2.getFinalVertex().lineID;
            if (dobj1_lineID != dobj2_lineID) {
                return dobj1_lineID - dobj2_lineID;
            }
            System.err.println("Drawable.Order: WARNING! Equal Drawables?\n" + dobj1 + "\n" + dobj2);
            return 0;
        }
    }
}

