/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class CustomCursor {
    public static Cursor Normal = null;
    public static Cursor Wait = null;
    public static Cursor Hand = null;
    public static Cursor HandOpen = null;
    public static Cursor HandClose = null;
    public static Cursor ZoomPlus = null;
    public static Cursor ZoomMinus = null;
    private static Toolkit toolkit = null;

    private URL getURL(String string) {
        return this.getClass().getResource("/images/" + string);
    }

    private Image getBestCursorImage(String string) {
        URL uRL = this.getURL(string);
        Image image = new ImageIcon(uRL).getImage();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Dimension dimension = toolkit.getBestCursorSize(n, n2);
        if (dimension.width == n && dimension.height == n2) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        System.out.println(string + ": (" + n + "," + n2 + ") -> (" + dimension.width + "," + dimension.height + ")");
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void initCursors() {
        Normal = Cursor.getPredefinedCursor(0);
        Wait = Cursor.getPredefinedCursor(3);
        Hand = Cursor.getPredefinedCursor(12);
        toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(1, 1);
        Image image = this.getBestCursorImage("HandOpenUpLeft25.gif");
        HandOpen = toolkit.createCustomCursor(image, point, "Hand Open");
        image = this.getBestCursorImage("HandCloseUpLeft25.gif");
        HandClose = toolkit.createCustomCursor(image, point, "Hand Close");
        image = this.getBestCursorImage("ZoomPlusUpLeft25.gif");
        ZoomPlus = toolkit.createCustomCursor(image, point, "Zoom Plus");
        image = this.getBestCursorImage("ZoomMinusUpLeft25.gif");
        ZoomMinus = toolkit.createCustomCursor(image, point, "Zoom Minus");
    }

    static {
        new CustomCursor().initCursors();
    }
}

