/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import viewer.common.LogFileChooser;
import viewer.convertor.ConvertorPanel;

public class ConvertorDialog
extends JDialog {
    private static final long serialVersionUID = 11100L;
    private ConvertorPanel top_panel;

    public ConvertorDialog(JFrame jFrame, LogFileChooser logFileChooser) {
        super(jFrame, "Logfile Convertor", true);
        super.setDefaultCloseOperation(0);
        this.top_panel = new ConvertorPanel(logFileChooser);
        super.setContentPane(this.top_panel);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConvertorDialog.this.setVisible(false);
                ConvertorDialog.this.dispose();
            }
        });
    }

    public void init(String string) {
        this.top_panel.init(string);
    }

    public static String convertLogFile(JFrame jFrame, LogFileChooser logFileChooser, String string) {
        ConvertorDialog convertorDialog = new ConvertorDialog(jFrame, logFileChooser);
        CloseToRetrieveAction closeToRetrieveAction = new CloseToRetrieveAction(convertorDialog);
        convertorDialog.top_panel.addActionListenerForOkayButton(closeToRetrieveAction);
        CloseAction closeAction = new CloseAction(convertorDialog);
        convertorDialog.top_panel.addActionListenerForCancelButton(closeAction);
        convertorDialog.pack();
        convertorDialog.init(string);
        convertorDialog.setVisible(true);
        return closeToRetrieveAction.getFilename();
    }

    private static class CloseToRetrieveAction
    implements ActionListener {
        private ConvertorDialog convertor;
        private String filename;

        public CloseToRetrieveAction(ConvertorDialog convertorDialog) {
            this.convertor = convertorDialog;
            this.filename = null;
        }

        public String getFilename() {
            return this.filename;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.filename = this.convertor.top_panel.getOutputSLOG2Name();
            this.convertor.setVisible(false);
            this.convertor.dispose();
        }
    }

    private static class CloseAction
    implements ActionListener {
        private ConvertorDialog convertor;

        public CloseAction(ConvertorDialog convertorDialog) {
            this.convertor = convertorDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.convertor.setVisible(false);
            this.convertor.dispose();
        }
    }
}

