//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include "welcomedialog.h"
#include "const.h"

WelcomeDialog::WelcomeDialog(QWidget *parent) : QDialog(parent) {
	textLabel = new QLabel;
	textLabel->setWordWrap(true);
	closeButton = new QPushButton(tr("Close"));
	connect(closeButton,SIGNAL(clicked()),this,SLOT(hide()));

	textLabel->setText(tr("You have started MountManager - a Linux program, made for easy and understandable mounting. You are running MountManager version %1 for the first time, that's why MountManager gives a piece of information.").arg(VERSION) + "<br><br><b>" + tr("Notice") + ":</b> " + tr("You should understand that management of storage devices is rather serious, that's why you should think twice before changing any options. MountManager will try to prevent some possible errors, but if you ruin your system with your inaccurate actions remember, that we take no responsibility over your actions.")
			+ "<br><br><b>" + tr("Request") + ":</b> " + tr("We will be very thankful if you send us a letter with your wishes and a log file from /var/log/MountManager.log to developer's e-mail: sstikhonov@gmail.com. It'll help us to develop the project.")
			+ "<br><br><b>" + tr("First actions") + ":</b> " + tr("MountManager has good documentation and you should read it. After loading the program press F1 and read \"Base information about mounting\" and \"More about program.\""));

	QHBoxLayout *bottomLayout = new QHBoxLayout;
	bottomLayout->addStretch();
	bottomLayout->addWidget(closeButton);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(textLabel);
	mainLayout->addLayout(bottomLayout);
	setLayout(mainLayout);
	setWindowTitle(tr("Welcome to MountManager!"));
	setFixedSize(sizeHint());
}

WelcomeDialog::~WelcomeDialog() {
	delete textLabel;
	delete closeButton;
}
