#ifndef USBMANAGER_H
#define USBMANAGER_H

#include <QtGui/QDialog>
#include <QtCore/QMap>

class TreeWidget;
class QPushButton;
class UsbWizard;
class PopupWindow;
class UdevRule;
class QAction;
class QTreeWidgetItem;
class QLabel;

class UdevFileParser
{
	public:
		UdevFileParser(const QString& fileName = QString());
		~UdevFileParser();
		
		const QList<UdevRule *>& getRules() const;
	
		void saveRules(QList<UdevRule *> rulesToSave);
	private:
		void parseFile();
	
		QList<UdevRule *> rules;
	
		QString filePath;
};

class UdevRuleViewer : public QWidget
{
	public:
		UdevRuleViewer();
		~UdevRuleViewer();
	
		void setRule(UdevRule *rule);
	private:
		QPushButton *closeButton;
		QLabel *label;
};

class UsbManager : public QDialog
{
	Q_OBJECT
	public:
		UsbManager(PopupWindow *popupWindow,QWidget *parent = 0);
		~UsbManager();
	
		UsbWizard *getWizard() const;
	private slots:
		void viewFullRule(QTreeWidgetItem *item = 0,int column = -1);
		void editRule(UdevRule *);
		void removeRule();
		void editRuleByWizard();
		void updateRuleView(UdevRule *rule);
		void createRule(UdevRule *newRule);
	private:
		void updateRulesView();
		void setRuleToItem(QTreeWidgetItem *item,UdevRule *rule);
	
		QMap<QTreeWidgetItem *,UdevRule *> rules;
	
		UsbWizard *usbWizard;
		UdevFileParser *parser;
		UdevRuleViewer *viewer;
	
		TreeWidget *rulesView;
	
		QPushButton *createRuleButton;
		QPushButton *editRuleButton;
		QPushButton *removeRuleButton;
	
		QAction *createRuleAction;
		QAction *editRuleAction;
		QAction *removeRuleAction;
		QAction *viewFullRuleAction;
};

#endif
