#ifndef UDEVRULE_H
#define UDEVRULE_H

#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QTextStream>

class UdevRule
{
	public:
		UdevRule();
	
		void setName(const QString& name);
		void setVendor(const QString& vendor);
		void setModel(const QString& model);
		void setSubsystem(const QString& subsystem);
		void setBus(const QString& bus);
		void setMountPoint(const QString& mountPoint);
		void setRemoveMountPoint(bool removeMountPoint);
		void setGroup(const QString& group);
		void setOwner(const QString& owner);
		void addOptionsWithFileSystem(const QString& fileSystem,const QString& options);
	
		void clearOptionsWithFileSystems();
	
		QString getName() const;
		QString getVendor() const;
		QString getModel() const;
		QString getSubsystem() const;
		QString getBus() const;
		QString getMountPoint() const;
		bool getRemoveMountPoint() const;
		QString getGroup() const;
		QString getOwner() const;
		const QMap<QString,QString>& getOptionsWithFileSystems() const;
	
		QString getFileStringOfTheRule();
		
		bool isNull() const;
	
	private:
		QString definitionRuleString();
	
		QString name;
		QString vendor;
		QString model;
		QString subsystem;
		QString bus;
		QString mountPoint;
		bool removeMountPoint;
		QString group;
		QString owner;
		QMap<QString,QString> optionsWithFileSystems;
};

#endif
