//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DOCUMENTATIONDIALOG_H
#define DOCUMENTATIONDIALOG_H

#include <QtGui/QDialog>
#include <QtGui/QTextBrowser>
#include <QtCore/QUrl>

class QToolButton;
class QFrame;
class QVBoxLayout;
class QHBoxLayout;
class QTimer;

struct Link
{
	QToolButton *linkView;
	QString linkSource;
	Link(QToolButton *view,const QString& source) {
		linkView = view;
		linkSource = source;
	}
};

class BrowserWithWidgets : public QTextBrowser
{
	Q_OBJECT
	public:
		BrowserWithWidgets();
		~BrowserWithWidgets();
		
		void addLink(const QString& linkHeader,const QString& sourcePath);
	private slots:
		void changeSource();
		void updateLinksSize();
		void showLinks();
	private:
		QTimer *timer;
		bool rollToDown;
	
		QFrame *buttonsFrame;
		QHBoxLayout *buttonsFrameLayout;
	
		QFrame *linksFrame;
		QVBoxLayout *linksFrameLayout;
	
		QToolButton *showLinksButton;
		QToolButton *backwardButton;
		QToolButton *forwardButton;
	
		QList<Link> links;
};

class Manual : public QDialog
{
	public:
		Manual(QWidget *parent = 0);
		~Manual();

		void saveSettings();
		void loadSettings();
	private:
		BrowserWithWidgets *browser;
		QString language;
};


#endif
