//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Images mounting"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef PLUGININTERFACE_H
#define PLUGININTERFACE_H

#include <QList>

class QDialog;
class QDockWidget;
class QToolBar;
class QMenu;

class QAction;

typedef QList<QAction *> Actions;

class MountManagerPlugin
{
	public:
		virtual ~MountManagerPlugin() { }

		// parent recieve signals about main program status
		virtual void setParent(QObject *parent) = 0;

		// Information about plugin
		virtual const QString pluginName() const = 0;
		virtual const QString pluginDescription() const = 0;
		
		virtual QDialog *dialog() const = 0;
		virtual QDockWidget *dockWidget() const = 0;
		virtual QMenu *menu() const = 0;
		virtual QToolBar *toolBar() const = 0;
		
		virtual Actions menuActions() const = 0;
};

Q_DECLARE_INTERFACE(MountManagerPlugin,"org.vialinx.MountManager.MountManagerPlugin/1.0")

#endif
