/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "javamanifest.h"

#include <qcstring.h>
#include <qstring.h>
#include <qtextstream.h>

JavaManifest::JavaManifest(const QByteArray& info, QObject *parent, const char *name)
 : QObject(parent, name)
{
	arr=info;
}


JavaManifest::~JavaManifest()
{
}

QString JavaManifest::getField(const QString& name)
{
	QTextStream stream(arr, IO_ReadOnly);
	QString str;
	QString exp=QString("%1: ").arg(name);
	char ok=0;
		
	while (!stream.eof())
	{
		str=stream.readLine();
		if (str.startsWith(exp, TRUE))
		{
			ok=1;
			break;
		}
	}
	if (!ok) return QString::null;
	str.remove(0,exp.length());
	str.remove(13);
	str.remove(10);
	return str.stripWhiteSpace();
}

QString JavaManifest::getMidletCaption()
{
	return getField("MIDlet-Name");
}

QString JavaManifest::getMidletVendor()
{
	return getField("MIDlet-Vendor");
}

QString JavaManifest::getMidletVersion()
{
	return getField("MIDlet-Version");
}

QString JavaManifest::getMidletName()
{
	QString str=getField("MIDlet-1");
	if (str.isNull()) return QString::null;
	return str.section(',',0,0).stripWhiteSpace();
}

QString JavaManifest::getMidletIcon()
{
	QString str=getField("MIDlet-Icon");
	if (!str.isNull()) return str;
	
	str=getField("MIDlet-1");
	if (str.isNull()) return QString::null;
	return str.section(',',1,1).stripWhiteSpace();
}

QString JavaManifest::getStartupClass()
{
	QString str=getField("MIDlet-1");
	if (str.isNull()) return QString::null;
	return str.section(',',2,2).stripWhiteSpace();	
}

