/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef JAVALISTVIEWITEM_H
#define JAVALISTVIEWITEM_H

#include <qlistview.h>

#include "midlet.h"

/*
Columns:
N = idx
Name = midletName
Vendor = midletVendor
Version = b2.b4.b6
Size = size[3]
Icon = ico1
Caption = menuName
startup = StarupClass
*/

class JavaListViewItem : public QListViewItem
{
public:
	JavaListViewItem(QListView *parent, const Midlet *midlet):
			QListViewItem(parent, QString::number(midlet->idx), QString(midlet->name), QString(midlet->vendor),
			              QString("%1.%2.%3").arg(QString::number(midlet->b2), QString::number(midlet->b4), QString::number(midlet->b6)),
			              QString::number(getMidletSize(midlet)),
		              QString( (midlet->ico1) ? "Yes" : "No"), QString(midlet->menuName), QString(midlet->startupClass))
	{};
	
	int compare (QListViewItem * i, int col, bool ascending) const;
	void getMidlet(Midlet *m);
};

#endif
