#ifndef SETDIRCOMMAND_H
#define SETDIRCOMMAND_H

/*
 *  setoutdircommand.h
 *  Mothur
 *
 *  Created by westcott on 1/21/10.
 *  Copyright 2010 Schloss Lab. All rights reserved.
 *
 */

#include "command.hpp"
#include "commandfactory.hpp"

/**********************************************************/

class SetDirectoryCommand : public Command {
	
public:
	SetDirectoryCommand(string);
	SetDirectoryCommand() { abort = true; calledHelp = true; setParameters(); }
	~SetDirectoryCommand(){}
	
	vector<string> setParameters();
	string getCommandName()			{ return "set.dir";		}
	string getCommandCategory()		{ return "General";		}
	string getHelpString();	
	
	int execute(); 
	void help() { m->mothurOut(getHelpString()); }	
	
private:
	CommandFactory* commandFactory;
	string output, input, tempdefault;
	bool abort;
	vector<string> outputNames;
	
		
};

/**********************************************************/
 
#endif

