# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-wmd',
    version='0.8',
    description='Windows messages listener',
    long_description='Listen for DEVICECHANGE win32 messages and inform Moovida about changes.',
    license='GPL3', 
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    platforms=['win32'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'elisa.plugins.wmd.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot']},
    cmdclass=cmdclass,
    entry_points="""
    [elisa.core.components.resource_provider]
    WMDResource = elisa.plugins.wmd.wmd_resource:WMDResource
    """)
