# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Fernando Casanova <fcasanova@fluendo.com>


from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation
from elisa.core.components.model import Model
from elisa.core import common
from elisa.core.action import ContextualAction
from elisa.plugins.poblesec.modal_popup import InformationPopup

_ = install_translation('poblesec')

class ShowPopupCloseMoovida(ContextualAction):
    def execute(self, item):
        main_controller = \
                 self.controller.frontend.retrieve_controllers('/poblesec')[0]

        title = _('CLOSE MOOVIDA')
        subtitle = _('Do you really want to close Moovida?')
        text = ''
        buttons = ((_('Cancel'), main_controller.hide_popup),
                   (_('Close Moovida'), common.application.stop))

        main_controller.enqueue_popup(title, subtitle, text, \
                                      buttons, InformationPopup)
        return defer.succeed(None)

def close_moovida_decorator(controller):
    entry = Model()
    entry.default_action = ShowPopupCloseMoovida(controller)
    entry.label = _("Close Moovida")
    controller.model.append(entry)
    return defer.succeed(None)

