val valid_utf8 : string -> bool

val error_notice : parent:#GWindow.window_skel -> string -> unit
val error_notice_f :
  parent:#GWindow.window_skel -> ('a, unit, string, unit) format4 -> 'a

val with_grab  : (unit -> 'a) -> 'a
val fold_in_loop : ?granularity:int -> ('a -> 'b -> 'a) -> 'a -> 'b list -> 'a

val wrap_in_scroll_window : (GObj.widget -> unit) -> GObj.widget -> unit
val add_label : text:string -> packing:(GObj.widget -> unit) -> unit

module Busy : sig
  type t
  val make : #GObj.widget -> t
  val start : t -> unit
  val stop  : t -> unit
end

val category :
  string ->
  (GObj.widget -> unit) ->
  ?from:Gtk.Tags.pack_type ->
  ?expand:bool -> ?fill:bool -> ?padding:int -> GObj.widget -> unit

class status_bar :
  packing:(GObj.widget -> unit) ->
  string ->
  App.status

module Prefs : sig
  val update_prefs :
    #App.t ->
    Viz_style.prefs -> Viz_style.prefs -> unit
  val show : #App.t -> unit -> unit
end

module Open : sig
  type t
  val make : #App.t -> t
  val show : t -> string option
end

(*
module LockedDB : sig
  val show : #App.t -> [`FAIL | `RETRY]
end
*)

type manager
val make  : unit -> manager * GObj.widget * GObj.widget
val setup : manager -> #App.t -> unit

val popup :
  manager -> #App.t ->
  popup_id:string -> int -> unit
val popup_cert : manager -> int -> unit
val open_db    : manager -> #App.t -> unit
val close_db   : manager -> #App.t -> unit
val clear      : manager -> unit
val update_begin : manager -> unit

