// introspect.cpp

/**
*    Copyright (C) 2008 10gen Inc.
*
*    This program is free software: you can redistribute it and/or  modify
*    it under the terms of the GNU Affero General Public License, version 3,
*    as published by the Free Software Foundation.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU Affero General Public License for more details.
*
*    You should have received a copy of the GNU Affero General Public License
*    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "pch.h"
#include "introspect.h"
#include "../bson/util/builder.h"
#include "../util/goodies.h"
#include "pdfile.h"
#include "jsobj.h"
#include "pdfile.h"

namespace mongo {

    void profile( const char *str, int millis)
    {
        BSONObjBuilder b;
        b.appendDate("ts", jsTime());
        b.append("info", str);
        b.append("millis", (double) millis);
        BSONObj p = b.done();
        theDataFileMgr.insert(cc().database()->profileName.c_str(),
                              p.objdata(), p.objsize(), true);
    }

} // namespace mongo
