#!/usr/bin/python

import os
import sys
import re
import utils

def getAllSourceFiles( arr=None , prefix="." ):
    if arr is None:
        arr = []

    for x in os.listdir( prefix ):
        if x.startswith( "." ) or x.startswith( "pcre-" ) or x.startswith( "32bit" ) or x.startswith( "mongodb-" ) or x.startswith("debian") or x.startswith( "mongo-cxx-driver" ):
            continue
        full = prefix + "/" + x
        if os.path.isdir( full ) and not os.path.islink( full ):
            getAllSourceFiles( arr , full )
        else:
            if full.endswith( ".cpp" ) or full.endswith( ".h" ) or full.endswith( ".c" ):
                arr.append( full )

    return arr

assertNames = [ "uassert" , "massert" ]

def assignErrorCodes():
    cur = 10000
    for root in assertNames:
        for x in getAllSourceFiles():
            print( x )
            didAnything = False
            fixed = ""
            for line in open( x ):
                s = line.partition( root + "(" )
                if s[1] == "" or line.startswith( "#define " + root):
                    fixed += line
                    continue
                fixed += s[0] + root + "( " + str( cur ) + " , " + s[2]
                cur = cur + 1
                didAnything = True
            if didAnything:
                out = open( x , 'w' )
                out.write( fixed )
                out.close()


codes = []

def readErrorCodes( callback ):
    ps = [ re.compile( "([um]asser(t|ted)) *\( *(\d+)" ) ,
           re.compile( "(User|Msg)Exceptio(n)\( *(\d+)" )
           ]
    for x in getAllSourceFiles():
        lineNum = 1
        for line in open( x ):
            for p in ps:               
                for m in p.findall( line ):
                    codes.append( ( x , lineNum , line , m[2] ) )
                    callback( x , lineNum , line , m[2] )
            lineNum = lineNum + 1
            

def getNextCode():
    highest = [0]
    def check( fileName , lineNum , line , code ):
        code = int( code )
        if code > highest[0]:
            highest[0] = code
    readErrorCodes( check )
    return highest[0] + 1

def checkErrorCodes():
    seen = {}
    errors = []
    def checkDups( fileName , lineNum , line , code ):
        if code in seen:
            print( "DUPLICATE IDS" )
            print( "%s:%d:%s %s" % ( fileName , lineNum , line.strip() , code ) )
            print( "%s:%d:%s %s" % seen[code] )
            errors.append( seen[code] )
        seen[code] = ( fileName , lineNum , line , code )
    readErrorCodes( checkDups )
    return len( errors ) == 0 

def getBestMessage( err , start ):
    err = err.partition( start )[2]
    if not err:
        return ""
    err = err.partition( "\"" )[2]
    if not err:
        return ""
    err = err.rpartition( "\"" )[0]
    if not err:
        return ""
    return err
    
def genErrorOutput():
    
    g = utils.getGitVersion()
    
    if os.path.exists( "docs/errors.md" ):
        i = open( "docs/errors.md" , "r" )
        
        
    out = open( "docs/errors.md" , 'w' )
    out.write( "MongoDB Error Codes\n==========\n\n\n" )

    prev = ""
    seen = {}
    
    codes.sort( key=lambda x: x[0]+"-"+x[3] )
    for f,l,line,num in codes:
        if num in seen:
            continue
        seen[num] = True

        if f.startswith( "./" ):
            f = f[2:]

        if f != prev:
            out.write( "\n\n" )
            out.write( f + "\n----\n" )
            prev = f

        url = "http://github.com/mongodb/mongo/blob/" + g + "/" + f + "#L" + str(l)
        
        out.write( "* " + str(num) + " [code](" + url + ") " + getBestMessage( line , str(num) ) + "\n" )
        
    out.write( "\n" )
    out.close()

if __name__ == "__main__":
    ok = checkErrorCodes()
    print( "ok:" + str( ok ) )
    print( "next: " + str( getNextCode() ) )
    if ok:
        genErrorOutput()

