/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: process.c,v 1.14 2004/08/27 20:06:19 ostborn Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

#include <pcre.h>

#include "config.h"
#include "mrecord.h"
#include "mlocale.h"
#include "mconfig.h"
#include "mplugins.h"
#include "mstate.h"
#include "mdatatypes.h"
#include "datatypes/state/datatype.h"
#include "datatypes/traffic/datatype.h"
#include "misc.h"

#include "plugin_config.h"

#define M_TRAFFIC_DIRECTION_UNSET	0
#define M_TRAFFIC_DIRECTION_INCOMING	1
#define M_TRAFFIC_DIRECTION_OUTGOING	2
#define M_TRAFFIC_DIRECTION_INTERNAL	3
#define M_TRAFFIC_DIRECTION_EXTERNAL	4

int mplugins_processor_traffic_insert_record(mconfig *ext_conf, mlist *state_list, mlogrec *record) {
	mlogrec_traffic *rectrf = NULL;
	/* HACK */
	mlogrec_traffic_flow *recflw = NULL;
	mstate_traffic *statrf = NULL;
	mdata *data = state_list->data;
	mstate *state = NULL;
	mhash *stasub = NULL;

	if (!data) {
		const char *key = splaytree_insert(ext_conf->strings, "");
		data = mdata_State_create(key,NULL,NULL);
		assert(data);
		mlist_insert(state_list, data);
	}

	state = data->data.state.state;

	if (state == NULL) return -1;

	if (record->ext_type != M_RECORD_TYPE_TRAFFIC || record->ext == NULL ) return -1;
	
	rectrf = record->ext;

	if (rectrf->ext_type == M_RECORD_TYPE_TRAFFIC_FLOW && rectrf->ext != NULL)
		recflw = rectrf->ext;

	if (state->ext) {
		switch(state->ext_type) {
		case M_STATE_TYPE_TRAFFIC:
			statrf = state->ext; break;
		default:
			fprintf(stderr, "%s.%d: unsupport state subtype\n", __FILE__, __LINE__);
			return -1;
		}
	} else {
		state->ext = mstate_init_traffic();
		state->ext_type = M_STATE_TYPE_TRAFFIC;

		statrf = state->ext;
	}


	state->timestamp = record->timestamp;


	switch(1) {
		case M_TRAFFIC_DIRECTION_INCOMING:
			stasub = statrf->incoming;
			break;
		case M_TRAFFIC_DIRECTION_OUTGOING:
			stasub = statrf->outgoing;
			break;
		case M_TRAFFIC_DIRECTION_INTERNAL:
			stasub = statrf->internal;
			break;
		case M_TRAFFIC_DIRECTION_EXTERNAL:
			stasub = statrf->external;
			break;
	}

	if (stasub) {
		/* HACK */
		mdata *data = NULL;
		
		data = mdata_Traffic_create(
					    rectrf->src,
					    rectrf->dst,
					    rectrf->xfer_incoming,
					    rectrf->xfer_outgoing,
					    recflw ? recflw->src_port : 0,
					    recflw ? recflw->dst_port : 0,
					    recflw ? recflw->src_as : 0,
					    recflw ? recflw->dst_as : 0,
					    recflw ? recflw->src_interface : 0,
					    recflw ? recflw->dst_interface : 0

		);
		mhash_insert_sorted(stasub, data);
	} else {
		fprintf(stderr, "%s.%d: *URGS* ?? \n", __FILE__, __LINE__);
		return -1;
	}

	return 0;
}



