#ifndef LIBBTTRACKER_TYPES_BTT_PEER_H
#define LIBBTTRACKER_TYPES_BTT_PEER_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdint.h>

#include <db.h>
#include <apr.h>
#include <apr_pools.h>

#include <libbtutil/const.h>

/* flags */
#define BTT_PEER_SHIELD         0x01
#define BTT_PEER_COMPACT        0x02
#define BTT_PEER_NOPEERID	0x04
#define BTT_PEER_SHUNNED        0x08
#define BTT_PEER_PASSIVE        0x10
#define BTT_PEER_HTML           0x20

#define BTT_PEER_KEEP_FLAGS     (BTT_PEER_SHIELD | BTT_PEER_SHUNNED)

#define BTT_PEER_IS_SEED(p)     (p->left == 0)
#define BTT_PEER_IS_SHIELD(p)   ( \
    (p->flags & BTT_PEER_SHIELD) && BTT_PEER_IS_SEED(p) \
)

#define BTT_PEER_IS_HIDDEN(p)   ( \
    BTT_PEER_IS_SHIELD(p) || (p->flags & BTT_PEER_SHUNNED) \
)

#define BTT_PEER_WANTS_PEERS(p) ( \
    (p->num_want != 0) && !(BTT_PEER_IS_HIDDEN(p)) \
)

typedef struct btt_peer_s {
    char                peerid[BT_PEERID_LEN];
    char                infohash[BT_INFOHASH_LEN];
    char                ua[BT_SHORT_STRING];            /* User-Agent */
    char                event[BT_EVENT_LEN];            /* Last Event Receieved */

    unsigned char       flags;                          /* flags */
 
    struct sockaddr_in  address;                        /* reported address */
    struct sockaddr_in  real_address;                   /* real address */
 
    time_t              first_t;
    time_t              last_t;
 
    time_t              first_serve_t;
    time_t              last_serve_t;
 
    time_t              complete_t;
    time_t              return_interval;

    uint32_t            hits;
    uint32_t            serves;
    int32_t             num_want;
    uint32_t            num_got;

    bt_off_t            announce_bytes;
    bt_off_t            uploaded;
    bt_size_t           downloaded;
    bt_size_t           left;
} btt_peer;

typedef struct btt_peer_flag_s {
    unsigned char       flag;
    char*               description;
    char*               config_name;
} btt_peer_flag;

extern const btt_peer new_btt_peer;
extern const btt_peer web_btt_peer;
extern const btt_peer_flag btt_peer_flags[];

extern int btt_peer_crossref(
    DB* dbp, const DBT* pkey, const DBT* pdata, DBT* skey
);
extern int btt_peer_req2struct(
    apr_pool_t* p, const char* args, btt_peer* peer
);

extern int btt_peer2compact(apr_pool_t* p, btt_peer* peer, char **result);
extern apr_size_t btt_peer2nopeerid(
    apr_pool_t* p, btt_peer* peer, char **result
);
extern apr_size_t btt_peer2bencode(
    apr_pool_t* p, btt_peer* peer, char **result
);
extern int btt_peer2tr(apr_pool_t* p, btt_peer* peer, char** result);

#endif /* LIBBTTRACKER_TYPES_BTT_PEER_H */
