/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* libc */
#include <stdio.h>
#include <time.h>
/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker.h>

/* data is set to the tracker */
/* modifies peer, saves */
int btt_iter_check_peer(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
) {
    btt_peer* peer = (btt_peer*) val->data;
    time_t now = time(NULL);
    int ret;
 
    if(!txn) {
        fprintf(
            stderr, "btt_iter_check_peer(): Called without a transaction!\n"
        );
        fflush(stderr);
        return DB_RUNRECOVERY;
    }
 
    if(
        ((now - peer->last_t) > (peer->return_interval * 2)) ||
        (!strcmp("stopped", peer->event))
    ) {
        if((ret = cursor->c_del(cursor, 0)) != 0)
            return ret;
   
        /* stop processing this peer if we've deleted it */
        return BT_CALLBACK_STOP;
    }
 
    return 0;
}
