#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <inttypes.h>

#include <libbttracker.h>

#ifdef BTT_WITH_LIBXML2
#include <libxml/tree.h>

static xmlChar __buffer[255];

#define DATA2XML(s,t) \
    if(!strcmp(description.format, s)) { \
        sprintf((char*)__buffer, description.format, *((t*)data)); \
    }

#define DATA2XMLC(s,c,t) \
    if(!strcmp(description.format, s)) { \
        sprintf((char*)__buffer, description.format, (c)*((t*)data)); \
    }

void btt_xml2data(xmlNodePtr node, btt_xml_node description, void* data) {
    xmlNodePtr text = node->children;
    xmlChar* content;
    
    if(!text) return;

    if(xmlNodeIsText(text)) {
        content = xmlNodeGetContent(text);
        if(!strcmp(description.format, "%s")) {
            strcpy((char*)data, (char*)content);
        } else {
            sscanf((char*)content, description.format, data);
        }
        xmlFree(content);
    } else {
        fprintf(stderr, "Warning: %s has a non-text child, ignored.\n", description.name);
        return;
    }
}

xmlNodePtr btt_data2xml(xmlNodePtr parent, btt_xml_node description, void* data) {
    if(!strcmp(description.format, "%s")) {
        strcpy((char*)__buffer, (char*)data);
    }
    else DATA2XML(BT_SIZE_T_FMT, bt_size_t)
    else DATA2XML(BT_OFF_T_FMT, bt_off_t)
    else DATA2XML(APR_SIZE_T_FMT, apr_size_t)
    else DATA2XML(APR_OFF_T_FMT, apr_off_t)
    else DATA2XML(BT_TIME_T_FMT, time_t)
    else DATA2XML("%"PRIu64, uint64_t)
    else DATA2XML("%"PRIu32, uint32_t)
    else DATA2XML("%"PRIu8, uint8_t)
    else {
        __buffer[0] = 0;
        fprintf(stderr, "Warning: %s is null: unknown format '%s'\n", description.name, description.format);
    }
    
    return xmlNewTextChild(parent, NULL, description.name, __buffer);    
}

void btt_struct2xml(xmlNodePtr parent, btt_xml_node* items, void* start) {
    int i;
    for(i=0;items[i].name;i++)
        btt_data2xml(parent, items[i], start + items[i].offset);
    return;
}

void btt_xml2struct(xmlNodePtr top, btt_xml_node* items, void* start) {
    int i;
    xmlNodePtr item;
    for(item=top->children; item; item=item->next) {
        for(i=0;items[i].name;i++) {
            if(!strcmp((char*)items[i].name, (char*)item->name)) {
                btt_xml2data(item, items[i], start + items[i].offset);
            }
        }
    }
    return;
}
#endif /* BTT_WITH_LIBXML2 */
