#ifndef LIBBTPEER_TYPES_BTPEER_H
#define LIBBTPEER_TYPES_BTPEER_H

#include <apr.h>
#include <apr_pools.h>
#include <apr_network_io.h>
#include <stdint.h>
#include <time.h>

#include <libbtutil/const.h>

#define BTP_PEER_STATE_ME_CHOKED        0x01
#define BTP_PEER_STATE_ME_INTERESTED    0x02
#define BTP_PEER_STATE_THEY_CHOKED      0x04
#define BTP_PEER_STATE_THEY_INTERESTED  0x08
#define BTP_PEER_STATE_SENT_HELLO       0x10
#define BTP_PEER_STATE_GOT_HELLO        0x20
#define BTP_PEER_STATE_IN_COMMAND       0x40

#define BTP_PEER_STATE_START              \
    BTP_PEER_STATE_ME_CHOKED & BTP_PEER_STATE_THEY_CHOKED

#define BTP_PEER_HELLO_MESSAGE          "\x13BitTorrent protocol"
#define BTP_PEER_HELLO_MESSAGE_LEN      20

#define BTP_PEER_MAX_REQUESTS           50

#define BTP_PEER_MSG_CHOKE              0
#define BTP_PEER_MSG_UNCHOKE            1
#define BTP_PEER_MSG_INTERESTED         2
#define BTP_PEER_MSG_UNINTERESTED       3
#define BTP_PEER_MSG_HAVE               4
#define BTP_PEER_MSG_BITFIELD           5
#define BTP_PEER_MSG_REQUEST            6
#define BTP_PEER_MSG_PIECE              7
#define BTP_PEER_MSG_CANCEL             8

typedef uint32_t btp_int_t;

typedef struct btp_peer_request_s {
    btp_int_t           piece;
    btp_int_t           begin;
    btp_int_t           length;
} btp_peer_request;

typedef struct btp_peer_s {
    apr_pool_t          *p;
    /* Data socket connecting us to a remote peer */
    apr_socket_t        *socket;
    
    char                id[BT_PEERID_LEN];
    time_t              created;
    time_t              last_sent;
    time_t              last_received;
    
    uint64_t            bytes_sent;
    uint64_t            bytes_received;
    uint64_t            data_sent;
    uint64_t            data_received;
    
    uint8_t             command;
    char                netbuf[BT_TINY_STRING];
    apr_size_t          netbuf_len;
    char*               cmdbuf;
    apr_size_t          cmdbuf_len;
    apr_size_t          cmdbuf_expected;
    
    btp_peer_request    requests[BTP_PEER_MAX_REQUESTS];
    
    uint8_t             state;
    uint8_t*            pieces;
} btp_peer;

extern btp_peer* btp_peer_create (apr_pool_t* p, apr_socket_t* s);
extern apr_status_t btp_peer_listen_socket(btp_peer* p, apr_socket_t *s);


extern apr_status_t btp_peer_send (
    btp_peer* p, const char* msg, apr_size_t* msglen
);

extern apr_status_t btp_peer_recv (btp_peer* p, char* msg, apr_size_t* msglen);

extern apr_status_t btp_peer_add_request(btp_peer* p, btp_peer_request req);
extern apr_status_t btp_peer_del_request(btp_peer* p, btp_peer_request req);
extern apr_status_t btp_peer_recv(btp_peer* p, char* msg, apr_size_t* msglen);
extern apr_status_t btp_peer_recv_no_cmd(btp_peer* p);
extern apr_status_t btp_peer_recv_in_cmd(btp_peer* p);


#endif /* LIBBTPEER_TYPES_BTPEER_H */
