#!@PERL@

use strict;
use warnings;
use vars qw(@ARGV);

use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use URI::Escape;

sub hashjunk
{
 my $junk = '';
 my $i;
 for $i (1 .. 20)
 {
  $junk.=chr(int(rand(255))+1);
 }
 return $junk;
}

if(open(RANDOM, "/dev/random"))
{
 my $junk;
 binmode(RANDOM);
 read(RANDOM, $junk, 2, 0);
 close(RANDOM);
 srand(ord(substr($junk, 0, 1)) + (ord(substr($junk, 1, 1))*256));
}
else
{
 die "couldn't open /dev/random";
}

if(!$ARGV[3])
{
 die "usage: $0 trackerurl hashcount peercount repeatcount\n";
}

my $ua = LWP::UserAgent->new;
my $i = 0;
my $k = 0;
my $s = time();
$|=1;

my $req;

while($i<$ARGV[1])
{
 print ".";
 $i++;
 my $hashid = hashjunk();
 my $j = 0;

 while($j<$ARGV[2])
 {
  $j++;
  my $port;
  my $peerid = hashjunk();
  $port = int(rand(30000)+3000);
  my $url = sprintf("%s?info_hash=%s&peer_id=%s&port=%s&downloaded=0&left=0&uploaded=0", $ARGV[0], uri_escape($hashid), uri_escape($peerid), $port);
  $k++;
  $req = HTTP::Request->new(GET => $url);
  my $response = $ua->request($req);
  if($response->is_error)
  {
   print "\n$url\n - ", $response->status_line, "\n-> ";
  }
 }
}

print "\n";

my $e = time();

printf("%s: %i hashes with %i peers each (%i requests total) in %i second(s) (%.02f reqs/s)\n", $ARGV[0], $ARGV[1], $ARGV[2], $k, $e - $s, $k / ($e - $s));

$s = time();
$i = 0;

printf("%i iterations on %s\n", $ARGV[3], $ARGV[0]);
while($i<$ARGV[3])
{
 $i++;
 $ua->request($req);
}
$e = time();

printf("\n%s: %i iterations on the same hash in %i second(s) (%.02f reqs/s)\n", $ARGV[0], $ARGV[3], $e - $s, $k / ($e - $s));

exit(0);
