#!/usr/bin/python -tt
# vim: ai ts=4 sts=4 et sw=4

#    Copyright (c) 2008 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
import re
import shutil
import sys
import tempfile
import unittest

DESTDIR = os.getenv('DESTDIR')
if DESTDIR:
    print "Not running unittest for build environment"
    sys.exit(0)
sys.path.insert(0, '/usr/share/moblin-media')

# Try importing all of our python modules
import constant
import hint_window
import image_finger
import media_info
import media_plugin
import media_service
import moblin_media
import music_view
import photo_playback
import photo_view
import playlist
import settings_dialog
import thumb_base
import thumbnail_creator
import thumbnail_view
import toolbar_view
import top_menu
import utils
import video_view

class TestMoblinMedia(unittest.TestCase):
    def setUp(self):
        self.workdir = tempfile.mkdtemp()
    def tearDown(self):
        if os.path.isdir(self.workdir):
            shutil.rmtree(self.workdir)
    def testInstantiate(self):
        pass

    #The following functions tests utils.py 
    def testTimeString(self):
        print "Test MoblinMedia..."
        timeStr = utils.formatTime(10, 0, 0)
        print "Time String for 10, 0, 0: %s" % timeStr
        timeStr = utils.formatTime(0, 0, 0)
        print "Time String for 0, 0: %s" % timeStr
        timeStr = utils.convertSecondsToString(3661)
        print "Convert Seconds to Hour, Min, Sec: 3661 = %s" % timeStr
    def testMediaType(self):
        mediaType = utils.get_media_type("")
        print "Media Type for \"\": %s" % mediaType
        mediaType = utils.get_media_type("None")
        print "Media Type for \"None\": %s" % mediaType
        mediaType = utils.get_media_type("None.")
        print "Media Type for \"None.\": %s" % mediaType
if __name__ == '__main__':
    unittest.main()
