#!/usr/bin/python -ttu
# -*- mode:python; tab-width:4; indent-tabs-mode:nil;  -*-
# vim: ai ts=4 sts=4 et sw=4
#
#    thumbnail_view.py: Manage the Thumbnail View
#    Copyright (c) 2007, 2008 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gettext
import Image
import ImageDraw
import gnome
import gnome.ui
import gtk
import md5
import os
import tempfile
import utils

# Import our libraries
import constant
import media_service

_ = gettext.lgettext

CONFIG_DIR = '.moblin-media'
THUMBNAIL_DIR = 'thumbnails'

# Constants
KIBIBYTE = 1024
MIBIBYTE = 1024 * KIBIBYTE
GIBIBYTE = 1024 * MIBIBYTE

class ThumbBase(object):
    """Base class of thumbnail for all modules"""

    def __init__(self):
        self.align_len = 40

    def set_align_len(self, length):
        self.align_len = length
        
    def calculate_size(self, bytes):
        """Get human readable size
        @ bytes is the size of file"""
        ret = ""
        if bytes < KIBIBYTE:
            ret = "%s bytes" % bytes
        elif bytes < MIBIBYTE:
            ret = "%.0f KB" % (bytes / KIBIBYTE / 1.0)
        elif bytes < GIBIBYTE:
            ret = "%.0f MB" % (bytes / MIBIBYTE / 1.0)
        else:
            ret = "%.0f GB" % (bytes / GIBIBYTE / 1.0)
        return ret
    
    def get_file_detail_info(self,filepath):
        """Get size and mtime info of given file
        @ filepath is the abs path of given file"""
        DeInfo = os.stat(filepath)
        return  DeInfo[-2],DeInfo[-4] 
    
    def align_name_with_thumb(self, image_file):
        new_image_file = ''
        if len(image_file) < self.align_len:
            return image_file
        i = 0
        while i < len(image_file):
            if i-self.align_len > len(image_file):
                j = i
            else:
                j = i + self.align_len
            new_image_file += image_file[i:j]+'\n'
            i = j
            
        return new_image_file   

    def thumb_filter(self,root,ext,isHide=False):
        """Filter out interested  media file and decide type of the interested ones
        Return values:
          1 : photo type 
          2 : audio type
          3 : video type
        Just check by the extension, not turely to read the media file content"""
        filepath=os.path.join(root,ext)
        pathlist = os.path.split(root)
        filefolder = pathlist[1]
        NewRoot, NewExt = os.path.splitext(filepath)
        NewExt = NewExt.replace('.','').lower()
        if NewExt in constant.MediaType['photo'] and filefolder == 'photo':
            return 1
        elif NewExt in constant.MediaType['audio'] and filefolder == 'audio':
            return 2
        elif  NewExt in  constant.MediaType['video'] and filefolder == 'video':
            return 3  
        return 0

    def select_home_size(self, is_sel_largest=True, thumbs_subdir=THUMBNAIL_DIR):
        config_dir = os.path.join(os.path.expanduser("~"), CONFIG_DIR)
        thumbs_dir = os.path.join(config_dir, thumbs_subdir)
        retval = ''
        if is_sel_largest:
            retval = os.path.join(thumbs_dir, 'largest')
        else: 
            retval = os.path.join(thumbs_dir, 'normal')  
        return retval

    def get_extension(self,uri):
        root,ext=os.path.splitext(uri)
        return ext.replace('.','').lower()

    def trash(self,src):
        root,filename = os.path.split(src)
        title = constant.MSG_CONFIRM_DELETE_TITLE
        msg = _(constant.MSG_CONFIRM_DELETE_QUESTION) % (filename)
        if gtk.RESPONSE_NO == utils.confirm_dialog(title, msg):
            return False
        os.unlink(src)
        return True
    
    def add_rectangle_for_pixbuf(self, pb, color=[255, 255, 255]):
        """Add a wider border to the selected thumbnail's pixbuf in 'color'
        @pb, the pixbuf to be deal with
        @color, the border color"""
        border_color = color
        pb_array = pb.get_pixels_array()
        try:
            #add width edge
            for i in range(len(pb_array[0])):
                for J in range(constant.BORDER):
                    pb_array[J][i] = (border_color)
                    pb_array[len(pb_array)-1-J][i] = (border_color)
            #add height edge
            for i in range(len(pb_array)):
                for j in range(constant.BORDER):
                    pb_array[i][j] = (border_color)
                    pb_array[i][len(pb_array[0])-1-j] = (border_color)
        except:
            pass
