#!/usr/bin/python -ttu
# vim: ai ts=4 sts=4 et sw=4

#    image_finger.py: image class that can do panning, resize, rotate and etc

#    Copyright (c) 2007, 2008 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gc
import gobject
import gtk
import moko
import os
import pygtk
import sys

pygtk.require("2.0")

class image_finger(gtk.EventBox):
    INDICATOR_AUTO, INDICATOR_SHOW, INDICATOR_HIDE = range(0,3)
    def __init__(self, panning = True):
        gtk.EventBox.__init__(self)
        self.set_above_child(False)
        self.show()
        self.image = gtk.Image()
        self.image.show()
        self.add(self.image)
        self.panning = panning
        if panning:
            self.moko_widget = moko.FingerScroll()
            self.moko_widget.show()
            self.moko_widget.set_property('spring_color',0x000000)
            self.moko_widget.add_with_viewport(self)
        self.image_file = None
        self.image_format = None
        self.image_pb = None
        self.fscreen = False
        self.resize_increaseby = 0
        self.area_size = None

    def get_resize_increaseby(self):
        return self.resize_increaseby        

    def get_moko(self):
        if self.panning :
            return self.moko_widget

    def get_image(self):
        return self.image

    def set_pic_size(self,value):
        if value <0 or value >30:
           return
        self.resize_increaseby = value
        return self._display_image_fit()

    def set_panning_vindicator(self, mode):
        if (self.panning):
            self.moko_widget.set_property("vindicator_mode", mode)
    
    def set_panning_hindicator(self, mode):
        if (self.panning):
            self.moko_widget.set_property("hindicator_mode", mode)

    def set_picture(self, image_file, fscreen = False):
        if not os.path.isfile(image_file):
            return False
        try:
            self.image_pb = gtk.gdk.pixbuf_new_from_file(image_file)
        except:
            return False
        else:
            self.image_file = image_file
            self.image_format = gtk.gdk.pixbuf_get_file_info(image_file)[0]['name']

        self.fscreen = fscreen
        self.resize_increaseby = 0
        self._display_image_fit()
        return True
      
    def set_full_screen(self,fullscreen):
        if (self.image_file == None):
            return False
        self.fscreen = fullscreen
        return self._display_image_fit()

    def init_size(self):
        self.area_size = self.get_allocation()

    def resize(self, keyval):
        if (self.image_file == None):
            return False
        if keyval in ['i','I']:
            self.resize_increaseby += 10
        if keyval in ['o','O']:
            self.resize_increaseby -= 10
        if self.resize_increaseby < 0:
            self.resize_increaseby = 0
        if self.resize_increaseby >30:
            self.resize_increaseby = 30
        return self._display_image_fit()
        
    def rotate(self, keyval):
        if (self.image_file == None):
            return False
        return self._display_image_fit(keyval)

    def _display_image_fit(self, rotate=None):
        if self.fscreen:
            size = gtk.gdk.Rectangle(0,0,0,0)
            size.width = self.image.get_screen().get_width()
            size.height = self.image.get_screen().get_height()
        else:
            if (self.area_size != None):
                size = self.area_size
            else:
                try:
                    size = self.image.get_parent().get_parent().get_allocation()
                except:
                    return

        if rotate == 'r':
            self.image_pb = self.image_pb.rotate_simple(gtk.gdk.PIXBUF_ROTATE_COUNTERCLOCKWISE)
        if rotate == 'R':
            self.image_pb = self.image_pb.rotate_simple(gtk.gdk.PIXBUF_ROTATE_CLOCKWISE)

        width = self.image_pb.get_width()
        height = self.image_pb.get_height()
        IncreaseBy = self.resize_increaseby
        image_pb = self.image_pb
        if IncreaseBy:
            if ((width > size.width) or (height > size.height)):
                if(width * size.height > height * size.width):
                    image_pb = self.image_pb.scale_simple( int( (1+IncreaseBy*0.05)*size.width ), int( (1+IncreaseBy*0.05)*height*size.width/width ), gtk.gdk.INTERP_BILINEAR )
                else:
                    image_pb = self.image_pb.scale_simple( int ((1+IncreaseBy*0.05)*width*size.height/height ), int ((1+IncreaseBy*0.05)*size.height ), gtk.gdk.INTERP_BILINEAR )
            else :
                image_pb = self.image_pb.scale_simple( int ((1+IncreaseBy*0.05)*width*size.height/height ), int ((1+IncreaseBy*0.05)*size.height ), gtk.gdk.INTERP_BILINEAR )
        else:
            if ((width > size.width) or (height > size.height)):
                if(width * size.height > height * size.width):
                    image_pb = self.image_pb.scale_simple( size.width , height*size.width/width, gtk.gdk.INTERP_BILINEAR )
                else:
                    image_pb = self.image_pb.scale_simple( width*size.height/height, size.height, gtk.gdk.INTERP_BILINEAR )

        # If we rotated the image, need to save it back to disk
        if rotate in ['R','r']:
            image_pb.save(self.image_file, self.image_format)

        self.image.set_from_pixbuf(image_pb)
        self.image.show()
        gc.collect()
