/*
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 * 1) start processes, add to list w/window title
 * 2) If process is running, bring to front
 * 3) If process dies, remove from running list
 */

#include "ProcessMgr.h"
#include "main.h"

#include <iostream>
#include <string>
#include <vector>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/errno.h>
#include <assert.h>
//#define NDEBUG

using namespace std;

//class is singleton, only accessible through this method
//static nsCOMPtr<FFPerfMon> m_pThis;
static ProcessMgr* m_pThis = NULL;

ProcessMgr* ProcessMgr::createInstance()
{
   if (m_pThis == NULL) {
      m_pThis = new ProcessMgr();
   }
   return m_pThis;
};

ProcessMgr::ProcessMgr ()
{
   m_errMsg = "";
}

ProcessMgr::~ProcessMgr()
{}


// launchProcess starts a new process.  It should keep track of running processes
// and if requested to re-launch, should first see if the process is running
// and if so, try to bring it to the front
bool ProcessMgr::launchProcess (string appPath) 
{
   int ret;
   pid_t pid = fork();
   if (pid < 0) { //error
      TRACE ("Failed to fork");
      m_errMsg = "Error: unable to spawn new process to launch " + appPath;
      return false;
   } else if (pid == 0) { //child
      cout << "Starting: " << appPath << endl;
      //split out parameters
      int ret;
      int spacePos = appPath.find_first_of(" ");
      if (spacePos == string::npos) { //no arguments
	 ret = execl (appPath.c_str(), appPath.c_str(), NULL);
      } else { //arguments passed... need to put them in char*[]
	 vector<string> args;
	 args.push_back (appPath.substr (0, spacePos));
	 do {
	    spacePos++; //move past space
	    int nextSpacePos = appPath.find_first_of(" ", spacePos);
	    if (nextSpacePos == spacePos+1) {
	       continue;  //skip multiple spaces
	    }
	    args.push_back (appPath.substr (spacePos, nextSpacePos-spacePos));
	    spacePos = nextSpacePos;
	 } while (spacePos != string::npos);

	 char **argv = new char *[args.size()+1];
	 for (int i=0; i<args.size(); i++) {
	    argv[i] = new char [args[i].length()+1];
	    strcpy ( argv[i], args[i].c_str());
	    TRACE ("Arg[" << i << "]: " << argv[i]);
	 }
	 argv[args.size()] = NULL;
	 ret = execv (argv[0], argv);
	 delete [] argv; //if error, delete memory
      }
      assert (ret < 0);
      cout << "Error launching..." << endl;
      if (ret == -1) {
	 cout << "Error: Failed to launch " << appPath << ", errno: " << errno << endl;
	 m_errMsg = "Error: unable to spawn new process to launch " + appPath;
      }
      exit (ret);
   } else { // parent
      //wait (&ret);
      //cout << "Parent: Finished waiting. ret=" << ret << endl;
      //if (ret < 0) {
      //cout << "Process error!" << endl;
      //}
   }
   return true;
}

string ProcessMgr::getErrorMessage() 
{
   cout << "debob8";
   return m_errMsg;
   cout << "debob9";
}

/*
   pid_t pid;
   int retval;
   int	commpipe[2];	// holds the fd for the input & output of the pipe

   // Setup communication pipeline first
   if(pipe(commpipe)){
      fprintf(stderr,"Pipe error!\n");
      exit(1);
   }

   // Attempt to fork and check for errors
   if( (pid=fork()) == -1){
      fprintf(stderr,"Fork error. Exiting.\n");  //something went wrong 
      return false;
   }
   cout << "launching process" << endl;
   if(pid){
      //A positive (non-negative) PID indicates the parent process 
dup2(commpipe[1],1);	// Replace stdout with out side of the pipe 
close(commpipe[0]);		// Close unused side of pipe (in side) 
setvbuf(stdout,(char*)NULL,_IONBF,0);	// Set non-buffered output on stdout 
wait(&retval);				// Wait for child process to end 

   }
   else{
// A zero PID indicates that this is the child process 
dup2(commpipe[0],0);	//Replace stdin with the in side of the pipe 
      close(commpipe[1]);		//Close unused side of pipe (out side) 
//Replace the child fork with a new process 
      if (execl (appPath.c_str(), appPath.c_str(), NULL) == -1) {
	 fprintf (stderr,"execl Error!");
	 exit(1);
      }
   }
}
*/
