/*
 * Message is the container for messages sent to the client
 * 
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */

#include "Message.h"
#include <iostream>

using namespace std;

Message::Message()
{
   LIBXML_TEST_VERSION
   m_xmlDoc = NULL;
}

Message::~Message() 
{
   if (m_xmlDoc) {
      xmlFreeDoc(m_xmlDoc);
   }
   xmlCleanupParser();
   xmlMemoryDump(); //debug
}

bool Message::isValid() {
   return (m_xmlDoc != NULL && m_type!=MSG_ERROR);
}

bool Message::load(string xmlstr) 
{
   m_type=MSG_ERROR; //default to ERR, changed based on input

   m_rawXml = xmlstr;

   //load string into xmlDoc
   m_xmlDoc = xmlReadMemory(xmlstr.c_str(), xmlstr.size(), "nofile.xml", NULL, 0);
   if (m_xmlDoc == NULL) {
      TRACE ("Error: Unable to parse xml input");
      return false;
   }
   xmlNode *node = xmlDocGetRootElement(m_xmlDoc);
   if (node == NULL) {
      TRACE ("Error: xml is empty");
      xmlFreeDoc(m_xmlDoc);
      return false;
   }

   TRACE ("Msg Rcvd: " << xmlstr);

   if (xmlStrcmp(node->name, (const xmlChar*) "hello")==0) {
      m_type = MSG_CONNECT_TEST;
   } else if (xmlStrcmp(node->name, (const xmlChar *) "applaunch")==0) {
      m_type = MSG_APP_LAUNCH;
   } else {
      return false;
   }
   return true;
}

int Message::getType() {
   return m_type;
}
bool Message::isType(int type) {
   return (type==m_type);
}
void Message::setType(int type) {
   m_type = type;
}

string Message::getField(string key) {

   string value = "";
   xmlNodePtr node = xmlDocGetRootElement(m_xmlDoc);

   if (node == NULL) {
      return "";
   }
   //if (node->hasAttribute(key.c_str())) {
   xmlChar *prop = xmlGetProp(node, (xmlChar*)key.c_str());
   value = (char*)prop;
   xmlFree(prop);
   return value;
}

void Message::empty() {
   m_rawXml = "";
   if (m_xmlDoc) {
      xmlFreeDoc(m_xmlDoc);
      m_xmlDoc = NULL;
   }
}   

string Message::getData() {
   return m_rawXml;
}
int Message::getDataSize() {
   return m_rawXml.size();
}
