/*
 * HacOutput provides the ability for the user to specify where to send the
 * output from the program (cout, cerr, or log file) without having to change
 * any of the underlying code that does the outputting.  It also provides locking
 * for the multiple threads.
 * 
 * Copyright 2004, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */
#ifndef __DBGOUT_H__
#define __DBGOUT_H__

#include <iostream>

#define DEBUG_TRACE 
#ifdef DEBUG_TRACE
#define TRACE(x) (std::cout << x << std::endl)
#else
#define TRACE(x)
#endif

#endif //__DBGOUT_H__
