      SUBROUTINE M_MEAN(IDA,IDB,AMEAN1,ASIG1)
C
C     Calculates the mean and sigma for each axis in a plot
C
#include "mnpar.inc"
#include "mninf.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
      REAL AMEAN1(*),ASIG1(*)
      DOUBLE PRECISION ZX,ZWT,ZMEAN,ZVAR,ZSIG,ZSUM0
     + ,ZSUM(2,MDIMMX)
      LOGICAL HEXIST
C
      IERR = 0
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4,'' does not exist'')') IDA,IDB
          CALL MN_ERR('M_MEAN',TXTERR)
          IERR = 1
          GOTO 9000
      ENDIF
C
C     See if HBOOK statistics were requested and if an HBOOK histogram exists
C
      IDH = IDA
      IF(QHSTAT .AND. HEXIST(IDH) .AND. NDIM.EQ.1) THEN
          AMEAN1(1) = HSTATI(IDH,1,'HIST',0)
          ASIG1(1)  = HSTATI(IDH,2,'HIST',0)
          GOTO 9000
      ENDIF
C
C     Loop over the data making the necessary sums
C
      NBIN = 0
      ZSUM0 = 0.0
C
C     Remember that ZSUM is double precision
C
      CALL VZERO_d(ZSUM,2*IABS(NDIM))
      DO 1000 JJ=1,NPNT
          ZWT = DBLE(AMNE(JJ,NH,IERR))
          ZSUM0 = ZSUM0 + ZWT
          NBLST = 1
          DO 500 II=1,IABS(NDIM)
              IF(NDIM.GT.0) THEN
                  IF(IDBIN(II).LE.0) GOTO 500
                  NBIN = MOD((JJ-1)/NBLST,IDBIN(II)) + 1
              ELSE
                  NBIN = JJ
              ENDIF
C
              ZX   = DBLE(AMNP(NBIN,NH,II,1,IERR))
c              ZSUM(1,II) = ZSUM(1,II) + ZWT*ZX
c              ZSUM(2,II) = ZSUM(2,II) + ZWT*ZX*ZX
              IF(ZWT.NE.0.0 .AND. ZSUM0.NE.0.0) THEN
                  ZSUM(2,II) = (ZSUM0-ZWT)/ZSUM0 *
     +             (ZSUM(2,II) +
     +              ZWT*(ZX - ZSUM(1,II))**2/ZSUM0)
C     +              (ZWT*ZX - ZSUM(1,II))**2/ZSUM0)
                  ZSUM(1,II) = (ZSUM0-ZWT)/ZSUM0 * ZSUM(1,II) +
     +             ZWT*ZX / ZSUM0
              ENDIF
              NBLST = NBLST * IDBIN(II)
C              IF(ABS(ZSUM(1,II)).GT.1.0E+31 .OR.
C     +           ABS(ZSUM(2,II)).GT.1.0E+31) THEN
C                  CALL M_EMSG('M_MEAN','Aborting mean calculation' //
C     +             ' to avoid floating overflow')
C                  GOTO 1010
C              ENDIF
500       CONTINUE
1000  CONTINUE
1010  CONTINUE
C
C     Calculate the quantities
C
      CALL VZERO_r(AMEAN1,IABS(NDIM))
      CALL VZERO_r(ASIG1,IABS(NDIM))
      DO 2000 II=1,IABS(NDIM)
C          IF(ZSUM0.EQ.0.0) THEN
C              ZMEAN = -1.0
C              ZSIG  = -1.0
C          ELSE
C              ZMEAN = ZSUM(1,II) / ZSUM0
C              ZVAR  = ZSUM(2,II) / ZSUM0 - ZMEAN**2
C              ZSIG  = DSQRT(DABS(ZVAR))
              ZMEAN = ZSUM(1,II)
              ZVAR  = ZSUM(2,II)
              ZSIG  = DSQRT(DABS(ZVAR))
C          ENDIF
          AMEAN1(II) = ZMEAN
          ASIG1(II)  = ZSIG
2000  CONTINUE
C
9000  CONTINUE
      END
