      SUBROUTINE M_BOOK(ID,TITLE,LDIM,IDBIN,ADLO,ADHI,LBPPT)
C
C     SUBROUTINE TO BOOK AN MNBOOK PLOT
C     ID    IS THE PLOT IDENTIFIER
C     TITLE IS THE TITLE
C     LDIM  IS THE NUMBER OF DIMENSIONS
C     IDBIN IS AN INTEGER ARRAY CONTAINING THE NUMBER OF BINS
C     ADLO  IS A REAL ARRAY CONTAINING THE LOWER LIMITS ON THE PLOT
C     ADHI  IS A REAL ARRAY CONTAINING THE UPPER LIMITS ON THE PLOT
C     LBPPT IS THE NUMBER OF BITS PER BIN
C           For an Ntuple it is the maximum number of points
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mntmp.inc"
#include "mnlun.inc"
C
      INTEGER IDBIN(*)
      REAL ADLO(*),ADHI(*)
      REAL ACONT(3**3)
      CHARACTER*(*) TITLE
      CHARACTER*32 TNAME(MDIMMX)
C
      IDA = ID
      IDB = NDIDB
      NDIM = LDIM
C
      IF(IDA.LE.0) THEN
          WRITE(TXTERR,'(''Illegal ID specified'',I7)') IDA
          CALL MN_ERR('M_BOOK',TXTERR)
          GOTO 9000
      ELSEIF(NDIM.EQ.0 .OR. IABS(NDIM).GT.MDIMMX) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     +     ,''  Illegal number of dimensions specified'',I4)')
     +     IDA,IDB,NDIM
          CALL MN_ERR('M_BOOK',TXTERR)
          GOTO 9000
      ENDIF
C
C     IF IDBIN(1).NE.0 WE HAVE A BINNED HISTOGRAM OTHERWISE IT
C     IS UNBINNED
C
      IF(IDBIN(1).GT.0) THEN
          NWPPT = 1
          NDIM = IABS(LDIM)
          NBPPT = LBPPT
          NPNT = 1
          DO 1000 II=1,NDIM
              NPNT = NPNT * IDBIN(II)
C
C             CHECK THAT SPECIFICATION IS OK
C
              IF(IDBIN(II).LE.0) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     +             ,'' Variable'',I4)') IDA,IDB,II
                  CALL M_EMSG('M_BOOK',TXTERR)
                  WRITE(TXTERR,'(''Error in number of bins'',I6)')
     +             IDBIN(II)
                  CALL MN_ERR('M_BOOK',TXTERR)
                  GOTO 9000
              ELSEIF((ADHI(II)-ADLO(II)).LE.0.0) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     +             ,'' Variable'',I4)') IDA,IDB,II
                  CALL M_EMSG('M_BOOK',TXTERR)
                  WRITE(TXTERR,'(''Error in limits'',2G11.4)')
     +             ADLO(II),ADHI(II)
                  CALL MN_ERR('M_BOOK',TXTERR)
                  GOTO 9000
              ENDIF
 1000     CONTINUE
          NWRD = NPNT * NWPPT
C
C     UNBINNED HISTOGRAM
C
      ELSE
          NDIM  = -IABS(LDIM)
          NWPPT = IABS(NDIM)
          IF(NDIM.EQ.-1) NWPPT = 2
          NPNT  = 0
          NPMAX = LBPPT
          IF(NPMAX.LE.0) NPMAX = 1000
          NWRD  = NPMAX * NWPPT
          NBPPT = 32
          DO 2000 II=1,IABS(NDIM)
              ADLO(II) = 1.0E+30
              ADHI(II) = -1.0E+30
2000      CONTINUE
      ENDIF
C
C     FILL IN THE VARIABLE NAMES
C
      if(ndim.ge.-1) then
          CALL TCOPY(TNDEF,TNAME,IABS(NDIM))
      else
          CALL TCOPY(TNNTP,TNAME,IABS(NDIM))
      endif
C
      EDENT = 0.0
      EDLO = 0.0
      EDHI = 1.0
      CALL VZERO_r(ACONT,3**MIN0(IABS(NDIM),3))
C
      NTMODE = 0
      CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
      IF(NH.LE.0) GOTO 9000
C
      NWTOT = NWH + NWRD
      CALL M_RTIM(NHDATE,NHTIME)
      NSDATE = 0
      NSTIME = 0
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDA,IDB,NDIM,NWPPT,NPNT
     1 ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE,' ',' ',TNAME)
      CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
 9000 CONTINUE
      RETURN
      END
