//------------------------------------------------------------------------
// Get the data for a histogram
//
// $Id: m_root_ent.cxx,v 1.3 2005/07/09 18:22:19 brock Exp $
//------------------------------------------------------------------------

#include "TDirectory.h"
#include "TH1.h"
#include "TMath.h"
#include <iostream>

using namespace std;
using namespace TMath;

extern "C" {
    int m_root_ent_(Int_t &leni, char *tidi,
		    Int_t &nwppt, Int_t &ndat,
		    Float_t &edent, Float_t &edlo, Float_t &edhi,
		    Float_t *acont, Float_t *rdat) {
	
	char* tid;
	tid = tidi;
	tid[leni] = 0;
	//gDirectory->ls();
	TH1 *h; 
	gDirectory->GetObject(tid,h);
	if ( h == 0 ) {
	    cout << "m_root_ent: Could not find histogram " << tid << endl;
	    return 1;
	}

	const char *classname;
	classname = h->ClassName();
	cout << "m_root_ent: " << tid << " is a " << classname << endl;

	Stat_t stats[11];
	h->GetStats(stats);

	// Get the information about the histograms
	Double_t e1 = 1.0e+30;
	Double_t e2 = -1.0e+30;
	Double_t ee = 0.0;
	if ( strncmp(classname,"TH1",3) == 0 ||
	     strcmp(classname,"TProfile") == 0 ) {
	    Int_t nbinsx = h->GetNbinsX();
	    Double_t ent, dent;
	    Double_t x, dx;
	    for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
		ent  = h->GetBinContent(nbinx);
		dent = h->GetBinError(nbinx);
		//cout << "Bin: " << nbinx 
		//   << ", Contents: " << ent << " +/- " << dent << endl;
		if ( nwppt == 2 ) {
		    rdat[nwppt*(nbinx-1)]   = ent;
		    rdat[nwppt*(nbinx-1)+1] = dent;
		} else {
		    x  = h->GetXaxis()->GetBinCenter(nbinx);
		    dx = 0.5*h->GetXaxis()->GetBinWidth(nbinx);
		    rdat[nwppt*(nbinx-1)+0] = x;
		    rdat[nwppt*(nbinx-1)+1] = ent;
		    rdat[nwppt*(nbinx-1)+2] = dx;
		    rdat[nwppt*(nbinx-1)+3] = dent;
		}

		ee = ee + ent;
		e1 = Min(e1,ent - dent);
		e2 = Max(e2,ent + dent);
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;
	    //cout << "Sum of weights: " << stats[0] << endl;
	    //cout << "Integral: " << h->Integral(1,nbinsx,"") << endl;
	    Float_t und = h->GetBinContent(0);
	    Float_t sum = stats[0];
	    Float_t ove = h->GetBinContent(nbinsx+1);
	    acont[0] = und;
	    acont[1] = sum;
	    acont[2] = ove;
	} else if ( strncmp(classname,"TH2",3) == 0 ||
		    strcmp(classname,"TProfile2D") == 0 ) {
	    Int_t nbinsx = h->GetNbinsX();
	    Int_t nbinsy = h->GetNbinsY();
	    Double_t ent, dent;
	    Double_t x, dx, y, dy;
	    Int_t nbin = 0;
	    for (Int_t nbiny=1; nbiny <= nbinsy; nbiny++) {
		for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
		    ent  = h->GetBinContent(nbinx,nbiny);
		    dent = h->GetBinError(nbinx,nbiny);
		    //cout << "Bin: " << nbinx 
		    //   << ", Contents: " << ent << " +/- " << dent << endl;
		    nbin++;
		    if ( nwppt == 2 ) {
			rdat[nwppt*(nbin-1)+0] = ent;
			rdat[nwppt*(nbin-1)+1] = dent;
		    } else {
			x  = h->GetXaxis()->GetBinCenter(nbinx);
			dx = 0.5*h->GetXaxis()->GetBinWidth(nbinx);
			y  = h->GetYaxis()->GetBinCenter(nbiny);
			dy = 0.5*h->GetYaxis()->GetBinWidth(nbiny);
			rdat[nwppt*(nbin-1)+0] = x;
			rdat[nwppt*(nbin-1)+1] = y;
			rdat[nwppt*(nbin-1)+2] = ent;
			rdat[nwppt*(nbin-1)+3] = dx;
			rdat[nwppt*(nbin-1)+4] = dy;
			rdat[nwppt*(nbin-1)+5] = dent;
		    }
		    
		    ee = ee + ent;
		    e1 = Min(e1,ent - dent);
		    e2 = Max(e2,ent + dent);
		}
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;

	    Int_t ixbin[3][2] = {
		{ 0, 0 },
		{ 1, nbinsx},
		{nbinsx+1, nbinsx+1}
	    };
	    Int_t iybin[3][2] = {
		{ 0, 0 },
		{ 1, nbinsy},
		{nbinsy+1, nbinsy+1}
	    };
	    Int_t nent=-1;
	    Double_t sum;
	    for (Int_t iy=0; iy<3; ++iy) {
		for (Int_t ix=0; ix<3; ++ix) {
		    sum = h->Integral(
			ixbin[ix][0],ixbin[ix][1],
			iybin[iy][0],iybin[iy][1],"");
			nent++;
		    acont[nent] = sum;
		    //cout << "Sum1 " << nent << " = " << acont[nent] << endl;
		}
	    }
	} else if ( strncmp(classname,"TH3",3) == 0 ) {
	    Int_t nbinsx = h->GetNbinsX();
	    Int_t nbinsy = h->GetNbinsY();
	    Int_t nbinsz = h->GetNbinsZ();
	    Double_t ent, dent;
	    Int_t nbin = 0;
	    for (Int_t nbinz=1; nbinz <= nbinsz; nbinz++) {
		for (Int_t nbiny=1; nbiny <= nbinsy; nbiny++) {
		    for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
			ent  = h->GetBinContent(nbinx,nbiny,nbinz);
			dent = h->GetBinError(nbinx,nbiny,nbinz);
			//cout << "Bin: " << nbinx 
			//   << ", Contents: " << ent << " +/- " << dent << endl;
			nbin++;
			rdat[nwppt*(nbin-1)]   = ent;
			rdat[nwppt*(nbin-1)+1] = dent;
			
			ee = ee + ent;
			e1 = Min(e1,ent - dent);
			e2 = Max(e2,ent + dent);
		    }
		}
	    }
	    Int_t ixbin[3][2] = {
		{ 0, 0 },
		{ 1, nbinsx},
		{nbinsx+1, nbinsx+1}
	    };
	    Int_t iybin[3][2] = {
		{ 0, 0 },
		{ 1, nbinsy},
		{nbinsy+1, nbinsy+1}
	    };
	    Int_t izbin[3][2] = {
		{ 0, 0 },
		{ 1, nbinsz},
		{nbinsz+1, nbinsz+1}
	    };
	    Int_t nent=-1;
	    Double_t sum;
	    for (Int_t iz=0; iz<3; ++iz) {
		for (Int_t iy=0; iy<3; ++iy) {
		    for (Int_t ix=0; ix<3; ++ix) {
			sum = h->Integral(
			    ixbin[ix][0],ixbin[ix][1],
			    iybin[iy][0],iybin[iy][1],
			    izbin[iz][0],izbin[iz][1],"");
			nent++;
			acont[nent] = sum;
			//cout << "Sum " << nent << " = " 
			//   << acont[nent] << endl;
		    }
		}
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;
	} else {
	    cout << "m_root_ent: " 
		 << tid << " is not a 1-D, 2-D, 3-D or Profile histogram: "
		 << classname << endl;
	    return 1;
	}
	return 0;
    }
}
