      DOUBLE PRECISION FUNCTION XMNPPM(AM12,ERES,EDAU,AMPI,LMODEL,ZPAR)
C
C     FUNCTION TO EVALUATE THE DIPION INVARIANT MASS SPECTRUM
C     FOR VARIOUS MODELS.
C     This routine performs the function normalization if it is needed
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnusr.inc"
C
      INTEGER MSTEP
      PARAMETER (MSTEP = 100)
C
      REAL AM12,ERES,EDAU,AMPI
      INTEGER LMODEL
      DOUBLE PRECISION ZPAR(MFNPAR)
C
      DOUBLE PRECISION DSIMPS
      DOUBLE PRECISION XMNPP2,WMNPPI,WPPVAL(0:MSTEP),WXLO,WXHI
     + ,WBIN
      DOUBLE PRECISION WXX,WDXX
      INTEGER I
      REAL ERESI,EDAUI,AMPII
      INTEGER LMODELI
      DOUBLE PRECISION ZPARI(MFNPAR)
      LOGICAL QPPNEW,qfarea_lst
C
      DOUBLE PRECISION ZAM12,ZERES,ZEDAU,ZAMPI
C
      SAVE ERESI,EDAUI,AMPII,LMODELI,ZPARI,WMNPPI,qfarea_lst
      DATA ERESI/-1.0E+31/,EDAUI/-1.0E+31/,AMPII/-1.0E+31/
     +    ,LMODELI/-999/,ZPARI/MFNPAR*-1.0D+31/
      data qfarea_lst/.false./
C
      ZAM12 = DBLE(AM12)
      ZERES = DBLE(ERES)
      ZEDAU = DBLE(EDAU)
      ZAMPI = DBLE(AMPI)
      WBIN  = DBLE(XBINNM)
C
      IF(QFAREA) THEN
C
C         See if any parameters have changed
C
          QPPNEW = (ERES.NE.ERESI) .OR. (EDAU.NE.EDAUI) .OR.
     +             (AMPI.NE.AMPII)
          DO I=2,MFNPAR
              IF(ZPAR(I).NE.ZPARI(I)) THEN
                  ZPARI(I) = ZPAR(I)
                  QPPNEW = .TRUE.
              ENDIF
          ENDDO
C
C         If they have changed then recalculate the AREA
C
          IF(QPPNEW .or. .not.qfarea_lst) THEN
              LMODELI = LMODEL
              ERESI   = ERES
              EDAUI   = EDAU
              AMPII   = AMPI
C
              WXLO     = 2.0D0*ZAMPI
              WXHI     = ZERES - ZEDAU
              ZPARI(1) = 1.0D0
              WDXX = (WXHI - WXLO) / DFLOAT(MSTEP)
              WXX  = WXLO - WDXX
              DO I=0,MSTEP
                  WXX = WXX + WDXX
                  WPPVAL(I) = XMNPP2(WXX,ZERES,ZEDAU,ZAMPI,1.0D0
     +             ,LMODEL,ZPARI(1))
              ENDDO
              WMNPPI = DSIMPS(WPPVAL(0), WXLO, WXHI, MSTEP)
          ENDIF
      ELSE
          WMNPPI = 1.0D0
      ENDIF
      qfarea_lst = qfarea
C
      XMNPPM = XMNPP2(ZAM12,ZERES,ZEDAU,ZAMPI,WBIN,LMODEL,ZPAR(1)) /
     + WMNPPI
C
      END

